/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.basic;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import javax.servlet.http.HttpServletRequest;

public class FirstUseFlowAction
extends JiraWebActionSupport {
    private final PageBuilderService pageBuilderService;
    private final PluginAccessor pluginAccessor;
    private final FeatureManager featureManager;

    public FirstUseFlowAction(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport FeatureManager featureManager) {
        this.pageBuilderService = pageBuilderService;
        this.pluginAccessor = pluginAccessor;
        this.featureManager = featureManager;
    }

    protected String doExecute() throws Exception {
        if (this.getLoggedInUser() == null) {
            return this.redirectToLogin();
        }
        if (this.pluginAccessor.isPluginEnabled("com.atlassian.analytics.analytics-client")) {
            this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.analytics.analytics-client:js-events");
        }
        if (this.featureManager.isEnabled("jira.onboarding.cyoa")) {
            this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.jira-onboarding-assets-plugin:jira-first-use-flow-new");
            this.pageBuilderService.assembler().resources().requireContext("atl.general");
            this.pageBuilderService.assembler().resources().requireContext("jira.project.add");
            this.pageBuilderService.assembler().resources().requireWebResource("jira.webresources:jira-fields");
        } else {
            this.pageBuilderService.assembler().resources().requireWebResource("com.atlassian.jira.jira-onboarding-assets-plugin:jira-first-use-flow");
        }
        return super.doExecute();
    }

    private String redirectToLogin() {
        HttpServletRequest request = this.getHttpRequest();
        String returnURL = request.getRequestURI().substring(request.getContextPath().length());
        if (request.getQueryString() != null) {
            returnURL = returnURL + "?" + request.getQueryString();
        }
        return this.getRedirect("/login.jsp?os_destination=" + JiraUrlCodec.encode((String)returnURL), false);
    }

    @ActionViewData
    public String getPageTitle() {
        return this.getText("onboarding.welcome.to.jira");
    }
}

