/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.osgi.impl;

import com.atlassian.upm.Functions;
import com.atlassian.upm.impl.CollectionUtils;
import com.atlassian.upm.osgi.Bundle;
import com.atlassian.upm.osgi.Package;
import com.atlassian.upm.osgi.PackageAccessor;
import com.atlassian.upm.osgi.Service;
import com.atlassian.upm.osgi.Version;
import com.atlassian.upm.osgi.VersionRange;
import com.atlassian.upm.osgi.impl.ServiceImpl;
import com.atlassian.upm.osgi.impl.Versions;
import com.atlassian.upm.osgi.impl.Wrapper;
import com.atlassian.upm.osgi.impl.Wrapper2;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.sling.commons.osgi.ManifestHeader;
import org.osgi.framework.ServiceReference;

public final class BundleImpl
implements Bundle {
    private final org.osgi.framework.Bundle bundle;
    private final PackageAccessor packageAccessor;
    private final Wrapper2<Function<Bundle.HeaderClause, Package>, ManifestHeader.Entry, Bundle.HeaderClause> wrapHeaderClause;
    private final Wrapper2<String, String, Iterable<Bundle.HeaderClause>> parseHeader;
    private static final Map<Integer, Bundle.State> states = ImmutableMap.builder().put((Object)1, (Object)Bundle.State.UNINSTALLED).put((Object)2, (Object)Bundle.State.INSTALLED).put((Object)4, (Object)Bundle.State.RESOLVED).put((Object)8, (Object)Bundle.State.STARTING).put((Object)16, (Object)Bundle.State.STOPPING).put((Object)32, (Object)Bundle.State.ACTIVE).build();
    private final Supplier<Map<String, String>> unparsedHeaders = Suppliers.memoize((Supplier)new Supplier<Map<String, String>>(){

        public Map<String, String> get() {
            return ImmutableMap.copyOf((Map)Maps.filterKeys((Map)BundleImpl.this.getHeaders(), (Predicate)Predicates.not((Predicate)parseable)));
        }
    });
    private final Supplier<Map<String, Iterable<Bundle.HeaderClause>>> parsedHeaders = Suppliers.memoize((Supplier)new Supplier<Map<String, Iterable<Bundle.HeaderClause>>>(){

        public Map<String, Iterable<Bundle.HeaderClause>> get() {
            return BundleImpl.this.parseHeader.fromSingletonValuedMap(Maps.filterKeys((Map)BundleImpl.this.getHeaders(), (Predicate)parseable));
        }
    });
    private static final Predicate<String> parseable = Predicates.in(CollectionUtils.immutableSetOf(new String[]{"Bundle-ClassPath", "Bundle-NativeCode", "Bundle-RequiredExecutionEnvironment", "DynamicImport-Package", "Export-Package", "Fragment-Host", "Ignore-Package", "Import-Package", "Private-Package", "Require-Bundle"}));
    private final Functions.Function2<String, Bundle.HeaderClause, Package> getPackageFn = new Functions.Function2<String, Bundle.HeaderClause, Package>(){

        @Override
        public Package apply(@Nullable String headerName, @Nullable Bundle.HeaderClause headerClause) {
            if ("Import-Package".equals(headerName) || "DynamicImport-Package".equals(headerName)) {
                String versionRange = headerClause.getParameters().get("version");
                return BundleImpl.this.packageAccessor.getImportedPackage(BundleImpl.this.getId(), headerClause.getPath(), VersionRange.fromString(versionRange == null ? "0" : versionRange));
            }
            if ("Export-Package".equals(headerName)) {
                String version = headerClause.getParameters().get("version");
                return BundleImpl.this.packageAccessor.getExportedPackage(BundleImpl.this.getId(), headerClause.getPath(), Versions.fromString(version == null ? "0" : version));
            }
            return null;
        }
    };

    BundleImpl(org.osgi.framework.Bundle bundle, PackageAccessor packageAccessor) {
        this.bundle = bundle;
        this.packageAccessor = packageAccessor;
        this.wrapHeaderClause = new Wrapper2<Function<Bundle.HeaderClause, Package>, ManifestHeader.Entry, Bundle.HeaderClause>(String.format("bundle-%d.headerClause", this.getId())){

            @Override
            protected Bundle.HeaderClause wrap(Function<Bundle.HeaderClause, Package> getPackageFn, ManifestHeader.Entry headerEntry) {
                return new HeaderClauseImpl(getPackageFn, headerEntry);
            }
        };
        this.parseHeader = new Wrapper2<String, String, Iterable<Bundle.HeaderClause>>(String.format("bundle-%d.header", this.getId())){

            @Override
            protected Iterable<Bundle.HeaderClause> wrap(@Nullable String headerName, @Nullable String headerEntries) {
                return BundleImpl.this.wrapHeaderClause.fromArray(Functions.curry(BundleImpl.this.getPackageFn).apply((Object)headerName), ManifestHeader.parse(headerEntries).getEntries());
            }
        };
    }

    @Override
    public Bundle.State getState() {
        return (Bundle.State)((Object)Preconditions.checkNotNull((Object)((Object)states.get(this.bundle.getState())), (Object)"state"));
    }

    @Override
    public Map<String, String> getUnparsedHeaders() {
        return (Map)this.unparsedHeaders.get();
    }

    @Override
    public Map<String, Iterable<Bundle.HeaderClause>> getParsedHeaders() {
        return (Map)this.parsedHeaders.get();
    }

    @Override
    public long getId() {
        return this.bundle.getBundleId();
    }

    @Override
    @Nullable
    public URI getLocation() {
        try {
            return new URI(this.bundle.getLocation());
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    @Override
    public Iterable<Service> getRegisteredServices() {
        return ServiceImpl.wrap(this.packageAccessor).fromArray((ServiceReference[])this.bundle.getRegisteredServices());
    }

    @Override
    public Iterable<Service> getServicesInUse() {
        return ServiceImpl.wrap(this.packageAccessor).fromArray((ServiceReference[])this.bundle.getServicesInUse());
    }

    @Override
    public String getSymbolicName() {
        return this.bundle.getSymbolicName();
    }

    @Override
    @Nullable
    public String getName() {
        return this.getUnparsedHeaders().get("Bundle-Name");
    }

    @Override
    public Version getVersion() {
        return Versions.wrap.fromSingleton(this.bundle.getVersion());
    }

    static Wrapper<org.osgi.framework.Bundle, Bundle> wrap(final PackageAccessor packageAccessor) {
        return new Wrapper<org.osgi.framework.Bundle, Bundle>("bundle"){

            @Override
            protected Bundle wrap(org.osgi.framework.Bundle bundle) {
                return new BundleImpl(bundle, packageAccessor);
            }
        };
    }

    private Map<String, String> getHeaders() {
        Dictionary headers = this.bundle.getHeaders();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Enumeration keys = headers.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)headers.get(key);
            builder.put((Object)key, (Object)value);
        }
        return builder.build();
    }

    public static class HeaderClauseImpl
    implements Bundle.HeaderClause {
        private final String path;
        private final Map<String, String> parameters;
        private final Function<Bundle.HeaderClause, Package> getPackageFn;

        HeaderClauseImpl(Function<Bundle.HeaderClause, Package> getPackageFn, ManifestHeader.Entry entry) {
            ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
            for (ManifestHeader.NameValuePair attribute : entry.getAttributes()) {
                propertiesBuilder.put((Object)attribute.getName(), (Object)attribute.getValue());
            }
            for (ManifestHeader.NameValuePair directive : entry.getDirectives()) {
                propertiesBuilder.put((Object)directive.getName(), (Object)directive.getValue());
            }
            this.getPackageFn = getPackageFn;
            this.path = (String)Preconditions.checkNotNull((Object)entry.getValue());
            this.parameters = propertiesBuilder.build();
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Map<String, String> getParameters() {
            return this.parameters;
        }

        @Override
        public Package getReferencedPackage() {
            return (Package)this.getPackageFn.apply((Object)this);
        }
    }
}

