/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.mac;

import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.license.internal.PluginLicenseRepository;
import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import java.util.Comparator;
import java.util.Iterator;

public class LicenseReceiptValidator {
    private final PluginLicenseRepository pluginLicenseRepository;

    public LicenseReceiptValidator(PluginLicenseRepository pluginLicenseRepository) {
        this.pluginLicenseRepository = (PluginLicenseRepository)Preconditions.checkNotNull((Object)pluginLicenseRepository, (Object)"pluginLicenseRepository");
    }

    public Option<ValidationError> validateReceivedLicense(PluginLicense newLicense, String pluginKey) {
        for (PluginLicense oldLicense : this.pluginLicenseRepository.getPluginLicense(pluginKey)) {
            if (!this.valueIsEquivalentOrHigher((Option)newLicense.getExpiryDate(), (Option)oldLicense.getExpiryDate(), (Comparator)Ordering.natural()) || !this.valueIsEquivalentOrHigher((Option)newLicense.getMaintenanceExpiryDate(), (Option)oldLicense.getMaintenanceExpiryDate(), (Comparator)Ordering.natural())) {
                return Option.some(ValidationError.EXPIRY_DATE_DOWNGRADE);
            }
            if (newLicense.isEvaluation() && !oldLicense.isEvaluation()) {
                return Option.some(ValidationError.EVAL_DOWNGRADE);
            }
            if (oldLicense.isEvaluation() || this.valueIsEquivalentOrHigher((Option)newLicense.getEdition(), (Option)oldLicense.getEdition(), (Comparator)Ordering.natural())) continue;
            return Option.some(ValidationError.EDITION_DOWNGRADE);
        }
        return Option.none();
    }

    private <T> boolean valueIsEquivalentOrHigher(Option<T> maybeNewValue, Option<T> maybeOldValue, Comparator<T> comparator) {
        Iterator<T> iterator = maybeNewValue.iterator();
        if (iterator.hasNext()) {
            T newValue = iterator.next();
            Iterator<T> iterator2 = maybeOldValue.iterator();
            if (iterator2.hasNext()) {
                T oldValue = iterator2.next();
                return comparator.compare(newValue, oldValue) >= 0;
            }
            return false;
        }
        return true;
    }

    public static enum ValidationError {
        EXPIRY_DATE_DOWNGRADE,
        EVAL_DOWNGRADE,
        EDITION_DOWNGRADE;

    }
}

