/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.upm.api.license.entity.Contact;
import com.atlassian.upm.api.license.entity.LicenseEditionType;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.Organization;
import com.atlassian.upm.api.license.entity.Partner;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.license.entity.SubscriptionPeriod;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.license.internal.LicenseToken;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.joda.time.DateTime;
import org.joda.time.Period;

public class TokenBasedPluginLicense
implements PluginLicense {
    private final LicenseToken licenseToken;
    private final DateTime licenseCreationDate;

    protected TokenBasedPluginLicense(LicenseToken licenseToken) {
        this.licenseToken = (LicenseToken)Preconditions.checkNotNull((Object)licenseToken, (Object)"licenseToken");
        this.licenseCreationDate = new DateTime();
    }

    @Override
    public String getPluginKey() {
        return this.licenseToken.getPluginKey();
    }

    @Override
    public boolean isEvaluation() {
        switch (this.licenseToken.getState()) {
            case ACTIVE_TRIAL: 
            case INACTIVE_TRIAL: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSubscription() {
        return true;
    }

    @Override
    public boolean isMaintenanceExpired() {
        return false;
    }

    @Override
    public boolean isValid() {
        return !this.getError().isDefined();
    }

    @Override
    public boolean isActive() {
        switch (this.licenseToken.getState()) {
            case ACTIVE_TRIAL: 
            case ACTIVE_SUBSCRIPTION: 
            case ACTIVE_SUBSCRIPTION_CANCELLED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isAutoRenewal() {
        switch (this.licenseToken.getState()) {
            case ACTIVE_TRIAL: 
            case ACTIVE_SUBSCRIPTION: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Option<LicenseError> getError() {
        switch (this.licenseToken.getState()) {
            case INACTIVE_TRIAL: 
            case INACTIVE_SUBSCRIPTION: {
                return Option.some(LicenseError.EXPIRED);
            }
        }
        return Option.none();
    }

    @Override
    public DateTime getCreationDate() {
        return this.licenseCreationDate;
    }

    @Override
    public String getRawLicense() {
        return this.licenseToken.toString();
    }

    @Override
    public Option<Integer> getLicenseVersion() {
        return Option.none();
    }

    @Override
    public String getPluginName() {
        return this.getPluginKey();
    }

    @Override
    public String getDescription() {
        return "License token for " + this.licenseToken.getPluginKey();
    }

    @Override
    public String getServerId() {
        return "[Server Id]";
    }

    @Override
    public Organization getOrganization() {
        return new Organization(){

            @Override
            public String getName() {
                return "[Organization]";
            }
        };
    }

    @Override
    public Option<Partner> getPartner() {
        return Option.none();
    }

    @Override
    public Iterable<Contact> getContacts() {
        return ImmutableList.of();
    }

    @Override
    public DateTime getPurchaseDate() {
        return this.licenseCreationDate;
    }

    @Override
    public Option<DateTime> getExpiryDate() {
        return Option.none();
    }

    @Override
    public Option<Period> getTimeBeforeExpiry() {
        return Option.none();
    }

    @Override
    public Option<String> getSupportEntitlementNumber() {
        return Option.none();
    }

    @Override
    public Option<DateTime> getMaintenanceExpiryDate() {
        return Option.none();
    }

    @Override
    public Option<Period> getTimeBeforeMaintenanceExpiry() {
        return Option.none();
    }

    @Override
    public Option<DateTime> getSubscriptionEndDate() {
        switch (this.licenseToken.getState()) {
            case ACTIVE_TRIAL: 
            case INACTIVE_TRIAL: 
            case ACTIVE_SUBSCRIPTION: 
            case ACTIVE_SUBSCRIPTION_CANCELLED: {
                return Option.some(this.licenseCreationDate.plusDays(30));
            }
        }
        return Option.some(this.licenseCreationDate.minusDays(1));
    }

    @Override
    public Option<Integer> getMaximumNumberOfUsers() {
        return Option.none();
    }

    @Override
    public Option<Integer> getEdition() {
        return Option.none();
    }

    @Override
    public LicenseEditionType getEditionType() {
        return LicenseEditionType.USER_COUNT;
    }

    @Override
    public boolean isUnlimitedNumberOfUsers() {
        return true;
    }

    @Override
    public boolean isUnlimitedEdition() {
        return true;
    }

    @Override
    public LicenseType getLicenseType() {
        return LicenseType.DEVELOPER;
    }

    @Override
    public String getLicenseTypeDescriptionKey() {
        return LicenseType.DEVELOPER.name();
    }

    @Override
    public boolean isEmbeddedWithinHostLicense() {
        return true;
    }

    @Override
    public boolean isEnterprise() {
        return this.isDataCenter();
    }

    @Override
    public boolean isDataCenter() {
        return true;
    }

    @Override
    public Option<SubscriptionPeriod> getSubscriptionPeriod() {
        return Option.none();
    }
}

