/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.license.internal.impl;

import com.atlassian.extras.api.Product;
import com.atlassian.plugin.Plugin;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.license.ProductLicense;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.upm.UpmPluginAccessor;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.SubscriptionPeriod;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.HostApplicationDescriptor;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.license.internal.HostApplicationEmbeddedAddonLicense;
import com.atlassian.upm.license.internal.HostApplicationLicense;
import com.atlassian.upm.license.internal.HostApplicationLicenseFactory;
import com.atlassian.upm.license.internal.HostApplicationLicenses;
import com.atlassian.upm.license.internal.LicenseEntityFactory;
import com.atlassian.upm.license.internal.ProductLicenses;
import com.atlassian.upm.license.internal.SalLicenses;
import com.atlassian.upm.license.internal.impl.role.RoleBasedLicensingPluginService;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class HostApplicationLicenseFactoryImpl
implements HostApplicationLicenseFactory {
    private final LicenseEntityFactory factory;
    private final HostApplicationDescriptor hostApplicationDescriptor;
    private final RoleBasedLicensingPluginService roleBasedService;
    private final ApplicationProperties applicationProperties;
    private final UpmPluginAccessor accessor;
    private final UpmAppManager appManager;

    public HostApplicationLicenseFactoryImpl(LicenseEntityFactory factory, HostApplicationDescriptor hostApplicationDescriptor, RoleBasedLicensingPluginService roleBasedService, ApplicationProperties applicationProperties, UpmPluginAccessor accessor, UpmAppManager appManager) {
        this.factory = (LicenseEntityFactory)Preconditions.checkNotNull((Object)factory, (Object)"factory");
        this.hostApplicationDescriptor = (HostApplicationDescriptor)Preconditions.checkNotNull((Object)hostApplicationDescriptor, (Object)"hostApplicationDescriptor");
        this.roleBasedService = (RoleBasedLicensingPluginService)Preconditions.checkNotNull((Object)roleBasedService, (Object)"roleBasedService");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.accessor = (UpmPluginAccessor)Preconditions.checkNotNull((Object)accessor, (Object)"accessor");
        this.appManager = (UpmAppManager)Preconditions.checkNotNull((Object)appManager, (Object)"appManager");
    }

    @Override
    public HostApplicationLicense getHostLicense(final com.atlassian.extras.api.ProductLicense productLicense, final String rawLicense) {
        Product product = productLicense.getProduct();
        Option<SubscriptionPeriod> subscriptionPeriod = Option.none();
        for (boolean monthly : ProductLicenses.isMonthlyOnDemandSubscription(productLicense)) {
            if (!monthly) continue;
            subscriptionPeriod = Option.some(SubscriptionPeriod.MONTHLY);
        }
        for (boolean annual : ProductLicenses.isAnnualOnDemandSubscription(productLicense)) {
            if (!annual) continue;
            subscriptionPeriod = Option.some(SubscriptionPeriod.ANNUAL);
        }
        ImmutableList embeddedAddonLicenses = ImmutableList.copyOf((Iterable)Iterables.transform(ProductLicenses.getEmbeddedPluginKeys(productLicense, this.applicationProperties.getDisplayName().toLowerCase()), (Function)new Function<String, HostApplicationEmbeddedAddonLicense>(){

            public HostApplicationEmbeddedAddonLicense apply(String pluginKey) {
                return HostApplicationLicenseFactoryImpl.this.getEmbeddedAddonLicense(productLicense, new Product(pluginKey, pluginKey, true), rawLicense, HostApplicationLicenseFactoryImpl.this.accessor.getPlugin(pluginKey));
            }
        }));
        Option<String> sen = this.ifNotBlank(Option.option(productLicense.getSupportEntitlementNumber()));
        Option<Integer> userOrEditionCount = product.equals((Object)Product.BAMBOO) ? ProductLicenses.getMaximumNumberOfRemoteAgents(productLicense, product) : ProductLicenses.getMaximumNumberOfUsers(productLicense, product);
        return new HostApplicationLicense(productLicense.isEvaluation(), ProductLicenses.isDataCenter(productLicense), ProductLicenses.isLegacyEnterprise(productLicense), ProductLicenses.isOnDemand(productLicense), ProductLicenses.isRoleBased(productLicense, product), ProductLicenses.isStarter(productLicense, product).getOrElse(false), ProductLicenses.isAutoRenewal(productLicense, product), product.getNamespace(), product.getNamespace(), product.getName(), LicenseType.valueOf(productLicense.getLicenseType().name()), productLicense.getServerId(), rawLicense, new DateTime((Object)productLicense.getPurchaseDate()), sen, subscriptionPeriod, userOrEditionCount, (Iterable<HostApplicationEmbeddedAddonLicense>)embeddedAddonLicenses, ProductLicenses.getLastModified(productLicense), ProductLicenses.getExpiryDate(productLicense));
    }

    @Override
    public HostApplicationLicense getHostLicense(final SingleProductLicenseDetailsView lic, final MultiProductLicenseDetails baseLic, String productKey, String rawLicense) {
        ImmutableList.Builder embeddedAddonLicenses = ImmutableList.builder();
        for (ProductLicense embeddedLicense : baseLic.getEmbeddedLicenses()) {
            String embeddedKey = embeddedLicense.getProductKey();
            if (!ProductLicenses.isSpecificPluginProduct(Product.fromNamespace((String)embeddedKey), this.applicationProperties.getPlatformId())) continue;
            embeddedAddonLicenses.add((Object)this.getEmbeddedAddonLicense(embeddedLicense, baseLic, rawLicense, this.accessor.getPlugin(ProductLicenses.getPluginKeyFromProductNamespace(embeddedKey))));
        }
        Option<Integer> edition = this.withNamespace(productKey, new Function<String, Option<Integer>>(){

            public Option<Integer> apply(String ns) {
                return SalLicenses.getEdition(lic, baseLic, ns);
            }
        });
        Option<SubscriptionPeriod> subscriptionPeriod = this.withNamespace(productKey, new Function<String, Option<SubscriptionPeriod>>(){

            public Option<SubscriptionPeriod> apply(String ns) {
                return SalLicenses.getSubscriptionPeriod(baseLic, ns);
            }
        });
        boolean eval = this.withNamespace(productKey, new Function<String, Option<Boolean>>(){

            public Option<Boolean> apply(String ns) {
                boolean val = SalLicenses.isEvaluation(baseLic, ns);
                return val ? Option.some(val) : Option.none(Boolean.class);
            }
        }).getOrElse(false);
        boolean autoRenewal = this.withNamespace(productKey, new Function<String, Option<Boolean>>(){

            public Option<Boolean> apply(String ns) {
                boolean val = SalLicenses.isAutoRenewal(baseLic, ns);
                return val ? Option.some(val) : Option.none(Boolean.class);
            }
        }).getOrElse(false);
        boolean roleBased = this.withNamespace(productKey, new Function<String, Option<String>>(){

            public Option<String> apply(String ns) {
                return Option.option(lic.getProperty(ProductLicenses.getNumRoleCountPropertyKey(new Product(ns, ns, true))));
            }
        }).isDefined();
        boolean starter = this.withNamespace(productKey, new Function<String, Option<Boolean>>(){

            public Option<Boolean> apply(String ns) {
                boolean val = SalLicenses.isStarter(baseLic, ns);
                return val ? Option.some(val) : Option.none(Boolean.class);
            }
        }).getOrElse(false);
        String encodedProductKey = this.withNamespace(productKey, new Function<String, Option<String>>(){

            public Option<String> apply(String ns) {
                return Option.option(lic.getProperty(SalLicenses.getActivePropertyKey(ns))).isDefined() ? Option.some(ns) : Option.none(String.class);
            }
        }).getOrElse(productKey);
        Option<String> sen = this.ifNotBlank(Option.option(lic.getSupportEntitlementNumber()));
        return new HostApplicationLicense(eval, lic.isDataCenter(), SalLicenses.isEnterprise(baseLic), SalLicenses.isOnDemand(baseLic), roleBased, starter, autoRenewal, productKey, encodedProductKey, lic.getProductDisplayName(), LicenseType.valueOf(lic.getLicenseTypeName()), lic.getServerId(), rawLicense, SalLicenses.getPurchaseDate(baseLic), sen, subscriptionPeriod, edition, (Iterable<HostApplicationEmbeddedAddonLicense>)embeddedAddonLicenses.build(), SalLicenses.getLastModified(baseLic), SalLicenses.getExpiryDate(baseLic));
    }

    private <T> Option<T> withNamespace(String productKey, Function<String, Option<T>> f) {
        ImmutableList namespaces = ImmutableList.of((Object)productKey, (Object)(this.applicationProperties.getPlatformId() + ".product." + productKey), (Object)this.applicationProperties.getPlatformId());
        for (String namespace : namespaces) {
            Option t = (Option)f.apply((Object)namespace);
            if (!t.isDefined()) continue;
            return t;
        }
        return Option.none();
    }

    private HostApplicationEmbeddedAddonLicense getEmbeddedAddonLicense(ProductLicense lic, final MultiProductLicenseDetails baseLic, String rawLicense, Option<Plugin> plugin) {
        String productKey = lic.getProductKey();
        Option<SubscriptionPeriod> subscriptionPeriod = this.withNamespace(productKey, new Function<String, Option<SubscriptionPeriod>>(){

            public Option<SubscriptionPeriod> apply(String ns) {
                return SalLicenses.getSubscriptionPeriod(baseLic, ns);
            }
        });
        HostApplicationLicenses.LicenseEditionAndRoleCount editionInfo = SalLicenses.getEditionAndRoleCountForEmbeddedLicense(baseLic, productKey, plugin, this.hostApplicationDescriptor, this.roleBasedService, this.applicationProperties, this.appManager);
        Option<String> sen = this.ifNotBlank(Option.option(baseLic.getSupportEntitlementNumber()));
        return new HostApplicationEmbeddedAddonLicense(SalLicenses.isEvaluation(baseLic, productKey), baseLic.isDataCenter(), SalLicenses.isEnterprise(baseLic), SalLicenses.isOnDemand(baseLic), SalLicenses.isAutoRenewal(baseLic, productKey), SalLicenses.isActive(baseLic, productKey).getOrElse(false), SalLicenses.isSubscription(baseLic), LicenseType.valueOf(baseLic.getLicenseTypeName().toUpperCase()), ProductLicenses.getPluginKeyFromProductNamespace(lic.getProductKey()), baseLic.getServerId(), rawLicense, baseLic.getDescription(), sen, subscriptionPeriod, editionInfo.edition, editionInfo.editionType, editionInfo.rbpMeta, SalLicenses.getLastModified(baseLic), SalLicenses.getSubscriptionEndDate(baseLic, lic.getProductKey()), SalLicenses.getMaintenanceExpiryDate(baseLic), SalLicenses.getExpiryDate(baseLic), SalLicenses.getPurchaseDate(baseLic), SalLicenses.getCreationDate(baseLic), SalLicenses.getLicenseVersion(baseLic), SalLicenses.getPartner(baseLic, this.factory), SalLicenses.getContacts(baseLic, this.factory), this.factory.getOrganization(baseLic.getOrganisationName()));
    }

    @Override
    public HostApplicationEmbeddedAddonLicense getEmbeddedAddonLicense(com.atlassian.extras.api.ProductLicense lic, Product product, String rawLicense, Option<Plugin> plugin) {
        Option<SubscriptionPeriod> subscriptionPeriod = Option.none();
        if (lic.isSubscription()) {
            for (boolean monthly : ProductLicenses.isMonthlyOnDemandSubscription(lic)) {
                if (!monthly) continue;
                subscriptionPeriod = Option.some(SubscriptionPeriod.MONTHLY);
            }
            for (boolean annual : ProductLicenses.isAnnualOnDemandSubscription(lic)) {
                if (!annual) continue;
                subscriptionPeriod = Option.some(SubscriptionPeriod.ANNUAL);
            }
        }
        HostApplicationLicenses.LicenseEditionAndRoleCount editionInfo = ProductLicenses.getEditionAndRoleCountForEmbeddedLicense(lic, product, plugin, this.hostApplicationDescriptor, this.roleBasedService, this.applicationProperties, this.appManager);
        Option<String> sen = this.ifNotBlank(Option.option(lic.getSupportEntitlementNumber()));
        return new HostApplicationEmbeddedAddonLicense(ProductLicenses.isEvaluation(lic, product), ProductLicenses.isDataCenter(lic), ProductLicenses.isLegacyEnterprise(lic), ProductLicenses.isOnDemand(lic), ProductLicenses.isAutoRenewal(lic, product), ProductLicenses.isActive(lic, product).getOrElse(false), lic.isSubscription(), LicenseType.valueOf(lic.getLicenseType().name()), ProductLicenses.getPluginKeyFromProductNamespace(product.getNamespace()), lic.getServerId(), rawLicense, lic.getDescription(), sen, subscriptionPeriod, editionInfo.edition, editionInfo.editionType, editionInfo.rbpMeta, ProductLicenses.getLastModified(lic), ProductLicenses.getSubscriptionEndDate(lic, product), ProductLicenses.getMaintenanceExpiryDate(lic), ProductLicenses.getExpiryDate(lic), new DateTime((Object)lic.getPurchaseDate()), new DateTime((Object)lic.getCreationDate()), ProductLicenses.getLicenseVersion(lic), ProductLicenses.getPartner(lic, this.factory), ProductLicenses.getContacts(lic, this.factory), this.factory.getOrganization(lic.getOrganisation()));
    }

    private Option<String> ifNotBlank(Option<String> str) {
        for (String s : str) {
            if (StringUtils.isBlank((String)s)) continue;
            return Option.some(s);
        }
        return Option.none(String.class);
    }
}

