/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.impl;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.upm.PluginControlHandlerRegistry;
import com.atlassian.upm.UpmPluginAccessor;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.spi.PluginControlHandler;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public class UpmPluginAccessorImpl
implements UpmPluginAccessor {
    private final PluginAccessor pluginAccessor;
    private final PluginControlHandlerRegistry pluginControllerHandlerRegistry;

    public UpmPluginAccessorImpl(PluginAccessor pluginAccessor, PluginControlHandlerRegistry pluginControllerHandlerRegistry) {
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.pluginControllerHandlerRegistry = (PluginControlHandlerRegistry)Preconditions.checkNotNull((Object)pluginControllerHandlerRegistry, (Object)"pluginControllerHanlderRegistry");
    }

    @Override
    public Option<Plugin> getPlugin(String pluginKey) {
        for (PluginControlHandler handler : this.getControlHandlers()) {
            if (!handler.canControl(pluginKey)) continue;
            return Option.some(handler.getPlugin(pluginKey));
        }
        return Option.option(this.pluginAccessor.getPlugin(pluginKey));
    }

    @Override
    public Iterable<Plugin> getPlugins() {
        ImmutableList.Builder plugins = ImmutableList.builder();
        plugins.addAll((Iterable)this.pluginAccessor.getPlugins());
        for (PluginControlHandler handler : this.getControlHandlers()) {
            plugins.addAll(handler.getPlugins());
        }
        return plugins.build();
    }

    @Override
    public boolean isPluginInstalled(String pluginKey) {
        return this.getPlugin(pluginKey).isDefined();
    }

    @Override
    public boolean isPluginEnabled(String pluginKey) {
        for (PluginControlHandler handler : this.getControlHandlers()) {
            if (!handler.canControl(pluginKey)) continue;
            return handler.isPluginEnabled(pluginKey);
        }
        return this.pluginAccessor.isPluginEnabled(pluginKey);
    }

    private Iterable<PluginControlHandler> getControlHandlers() {
        return this.pluginControllerHandlerRegistry.getHandlers();
    }

    @Override
    public Option<ModuleDescriptor<?>> getPluginModule(String completeModuleKey) {
        ModuleDescriptor module = this.pluginAccessor.getPluginModule(completeModuleKey);
        if (module == null) {
            return Option.none();
        }
        return Option.some(module);
    }

    @Override
    public boolean isPluginModuleEnabled(String completeModuleKey) {
        return this.pluginAccessor.isPluginModuleEnabled(completeModuleKey);
    }
}

