/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.rest;

import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.core.Sys;
import com.google.common.base.Preconditions;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;

public abstract class CoreUriBuilder {
    private final ApplicationProperties applicationProperties;
    private final String baseUrl;

    protected CoreUriBuilder(ApplicationProperties applicationProperties, String baseUrl) {
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.baseUrl = (String)Preconditions.checkNotNull((Object)baseUrl, (Object)"baseUrl");
    }

    public final URI makeAbsolute(URI uri) {
        return this.makeAbsolute(URI.create(this.applicationProperties.getBaseUrl()), uri);
    }

    protected final URI makeAbsolute(URI base, URI path) {
        if (path.isAbsolute()) {
            return path;
        }
        return base.resolve(path).normalize();
    }

    protected UriBuilder newApplicationBaseUriBuilder() {
        URI base = URI.create(this.applicationProperties.getBaseUrl()).normalize();
        return UriBuilder.fromPath((String)base.getPath());
    }

    protected UriBuilder newPluginBaseUriBuilder() {
        return this.newApplicationBaseUriBuilder().path(this.baseUrl);
    }

    public URI buildAtlassianIdLoginUri() {
        return URI.create(Sys.getAtlassianIdBaseUrl() + "/id/rest/login");
    }

    public URI buildShoppingCartUri() {
        return URI.create(Sys.getShoppingCartBaseUrl());
    }

    public URI buildGoAtlassianUri(String redirectPath) {
        return URI.create(Sys.getGoAtlassianBaseUrl() + redirectPath);
    }

    public URI buildMpacBaseurl() {
        return URI.create(Sys.getMpacBaseUrl());
    }

    public URI buildMacCreateAppEvalLicenseUri() {
        return URI.create(Sys.getMacBaseUrl() + "/license/evaluation");
    }

    public URI buildHamletCreateEvalLicenseUri() {
        return URI.create(Sys.getHamletBaseUrl() + "/1.0/public/license/createEvaluation");
    }

    public URI buildBillingProxyUri() {
        return URI.create(Sys.getMacBillingUrl() + "/proxy");
    }
}

