/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.install;

import com.atlassian.plugin.DefaultPluginArtifactFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginArtifact;
import com.atlassian.plugin.PluginArtifactFactory;
import com.atlassian.plugin.PluginController;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.upm.Iterables;
import com.atlassian.upm.UpmPluginAccessor;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.DefaultHostApplicationInformation;
import com.atlassian.upm.core.Plugins;
import com.atlassian.upm.core.SafeModeAccessor;
import com.atlassian.upm.core.SafeModeException;
import com.atlassian.upm.core.install.AbstractPluginInstallHandler;
import com.atlassian.upm.core.install.ContentTypes;
import com.atlassian.upm.core.install.JarHelper;
import com.atlassian.upm.core.install.PluginDescriptor;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.spi.PluginInstallException;
import com.atlassian.upm.spi.PluginInstallResult;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.osgi.framework.BundleContext;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class ObrPluginInstallHandler
extends AbstractPluginInstallHandler
implements DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(ObrPluginInstallHandler.class);
    private final BundleContext bundleContext;
    private PluginArtifactFactory pluginArtifactFactory = new DefaultPluginArtifactFactory();
    private ServiceTracker repositoryAdminServiceTracker;
    private SafeModeAccessor safeMode;
    private static Predicate<PluginArtifact> isPrimaryApplicationPlugin = new Predicate<PluginArtifact>(){

        public boolean apply(PluginArtifact artifact) {
            Iterator<JarHelper> iterator = JarHelper.fromFile(artifact.toFile()).iterator();
            if (iterator.hasNext()) {
                JarHelper jar = iterator.next();
                return jar.isPrimaryApplicationPlugin().getOrElse(false);
            }
            return false;
        }
    };
    private final Function<Resource, PluginArtifact> pluginArtifactFromResource = new Function<Resource, PluginArtifact>(){

        public PluginArtifact apply(Resource res) {
            return ObrPluginInstallHandler.this.pluginArtifactFactory.create(URI.create(res.getURL().toString()));
        }
    };

    public ObrPluginInstallHandler(BundleContext bundleContext, DefaultHostApplicationInformation hostApplicationInformation, PermissionEnforcer permissionEnforcer, UpmPluginAccessor pluginAccessor, PluginController pluginController, TransactionTemplate txTemplate, SafeModeAccessor safeMode) {
        super(hostApplicationInformation, permissionEnforcer, pluginAccessor, pluginController, txTemplate);
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext, (Object)"bundleContext");
        this.safeMode = (SafeModeAccessor)Preconditions.checkNotNull((Object)safeMode, (Object)"safeMode");
    }

    @VisibleForTesting
    public void setRepositoryAdminServiceTracker(ServiceTracker repositoryAdminServiceTracker) {
        if (this.repositoryAdminServiceTracker != null) {
            this.repositoryAdminServiceTracker.close();
        }
        this.repositoryAdminServiceTracker = (ServiceTracker)Preconditions.checkNotNull((Object)repositoryAdminServiceTracker);
    }

    @VisibleForTesting
    public void setPluginArtifactFactory(PluginArtifactFactory factory) {
        this.pluginArtifactFactory = factory;
    }

    public void destroy() {
        if (this.repositoryAdminServiceTracker != null) {
            this.repositoryAdminServiceTracker.close();
        }
    }

    @Override
    public boolean canInstallPlugin(File pluginFile, Option<String> contentType) {
        for (String ct : contentType) {
            if (ContentTypes.matchContentType("application/java-archive", ct)) continue;
            return false;
        }
        Iterator<Object> iterator = JarHelper.fromFile(pluginFile).iterator();
        if (iterator.hasNext()) {
            JarHelper jar = (JarHelper)iterator.next();
            return jar.isObr();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PluginInstallResult installPluginInternal(File pluginFile, Option<String> contentType) throws PluginInstallException {
        if (this.repositoryAdminServiceTracker == null) {
            ObrPluginInstallHandler obrPluginInstallHandler = this;
            synchronized (obrPluginInstallHandler) {
                if (this.repositoryAdminServiceTracker == null) {
                    this.repositoryAdminServiceTracker = new ServiceTracker(this.bundleContext, RepositoryAdmin.class.getName(), null);
                    this.repositoryAdminServiceTracker.open();
                }
            }
        }
        RepositoryAdmin repositoryAdmin = (RepositoryAdmin)Preconditions.checkNotNull((Object)this.repositoryAdminServiceTracker.getService(), (Object)"couldn't locate RepositoryAdmin service");
        File obrDir = JarHelper.expandObrFile(pluginFile);
        URI repoUri = new File(obrDir, "obr.xml").toURI();
        try {
            String mainBundleName;
            repositoryAdmin.addRepository(repoUri.toURL());
            Resolver resolver = repositoryAdmin.resolver();
            Iterable<JarHelper> jars = JarHelper.findJarsToInstall(obrDir);
            if (com.google.common.collect.Iterables.size(jars) != 1) {
                throw new PluginInstallException("Attempted to install an OBR that does not have exactly one main plugin jar", false);
            }
            JarHelper mainJar = (JarHelper)com.google.common.collect.Iterables.getOnlyElement(jars);
            String mainPluginKey = mainBundleName = this.extractBundleName(mainJar);
            for (PluginDescriptor descriptor : this.validateJarIsInstallable(mainJar)) {
                Iterator<String> iterator = descriptor.getPluginKey().iterator();
                while (iterator.hasNext()) {
                    String key;
                    mainPluginKey = key = iterator.next();
                }
            }
            Resource resource = repositoryAdmin.discoverResources("(symbolicname=" + mainBundleName + ")")[0];
            resolver.add(resource);
            if (resolver.resolve()) {
                PluginInstallResult pluginInstallResult = this.installResources(resolver, mainPluginKey);
                return pluginInstallResult;
            }
            try {
                ObrPluginInstallHandler.logUnsatisfiedRequirements(pluginFile, resolver.getUnsatisfiedRequirements());
                throw new PluginInstallException("Failed to resolve plugin dependencies within OBR [" + pluginFile.getName() + "]. Please see the logs for more detailed information.", false);
            }
            catch (PluginInstallException e) {
                throw e;
            }
            catch (SafeModeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new PluginInstallException("Failed to install OBR jar artifact", e);
            }
        }
        finally {
            try {
                repositoryAdmin.removeRepository(repoUri.toURL());
                FileUtils.deleteDirectory((File)obrDir);
            }
            catch (Exception e) {
                log.warn("Failed to remove local OBR repository resources");
            }
        }
    }

    private static void logUnsatisfiedRequirements(File plugin, Requirement[] unsatisfiedRequirements) {
        if (unsatisfiedRequirements != null) {
            log.error("OBR resolver has {} unsatisfied requirements for installing {}", (Object)unsatisfiedRequirements.length, (Object)plugin.getName());
            for (Requirement requirement : unsatisfiedRequirements) {
                log.error("Unsatisfied requirement: {}", (Object)requirement.getFilter());
            }
        } else {
            log.error("OBR resolver failed to resolve, but provided no additional information");
        }
    }

    private PluginInstallResult installResources(Resolver resolver, String mainPluginKey) throws PluginInstallException, URISyntaxException {
        Iterable requiredArtifacts = com.google.common.collect.Iterables.transform(Arrays.asList(resolver.getRequiredResources()), this.pluginArtifactFromResource);
        Iterable optionalArtifacts = com.google.common.collect.Iterables.transform(Arrays.asList(resolver.getOptionalResources()), this.pluginArtifactFromResource);
        ImmutableList allDependencies = ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.concat((Iterable)requiredArtifacts, (Iterable)optionalArtifacts));
        for (PluginArtifact dep : allDependencies) {
            for (JarHelper jarHelper : JarHelper.fromFile(dep.toFile())) {
                this.validateJarIsInstallable(jarHelper);
            }
        }
        Resource mainPluginResource = resolver.getAddedResources()[0];
        PluginArtifact mainArtifact = (PluginArtifact)this.pluginArtifactFromResource.apply((Object)mainPluginResource);
        Option<JarHelper> mainJar = JarHelper.fromFile(mainArtifact.toFile());
        for (JarHelper jar : mainJar) {
            this.validateJarIsInstallable(jar);
        }
        ImmutableList immutableList = ImmutableList.copyOf((Iterable)com.google.common.collect.Iterables.concat((Iterable)allDependencies, (Iterable)ImmutableList.of((Object)mainArtifact)));
        if (this.safeMode.isSafeMode() && Iterables.none(immutableList, isPrimaryApplicationPlugin)) {
            throw new SafeModeException("Install OBR plugin is not allowed when system is in safe mode");
        }
        Iterable<Plugin> allInstalled = this.installArtifacts((Iterable<PluginArtifact>)immutableList);
        Option<Plugin> mainInstalled = Iterables.findOption(allInstalled, Predicates.compose((Predicate)Predicates.equalTo((Object)mainPluginKey), Plugins.plugToPluginKey));
        Iterator<Plugin> iterator = mainInstalled.iterator();
        if (iterator.hasNext()) {
            Plugin main = iterator.next();
            Iterable others = com.google.common.collect.Iterables.filter(allInstalled, (Predicate)Predicates.compose((Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)mainPluginKey)), Plugins.plugToPluginKey));
            return new PluginInstallResult(main, others);
        }
        throw new PluginInstallException("Unknown error, plugin not installed");
    }

    @VisibleForTesting
    String extractBundleName(JarHelper jar) throws IOException {
        Iterator<String> iterator = jar.getBundleSymbolicName().iterator();
        if (iterator.hasNext()) {
            String name = iterator.next();
            return name;
        }
        String name = jar.getFile().getName();
        return name.endsWith(".jar") ? name.substring(0, name.length() - ".jar".length()) : name;
    }
}

