/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.install;

import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.core.Sys;
import com.atlassian.upm.core.impl.Uris;
import com.atlassian.upm.core.install.ContentTypes;
import com.atlassian.upm.core.install.InvalidDescriptorException;
import java.io.File;
import java.net.URI;

public abstract class ConnectDescriptors {
    public static boolean isConnectDescriptor(File pluginFile, Option<String> contentType) {
        try {
            return ContentTypes.isJson(pluginFile, contentType);
        }
        catch (InvalidDescriptorException e) {
            return false;
        }
    }

    public static Option<String> hasRemotePluginDescriptorNotFromMarketplaceError(URI uri, boolean sideLoading, SysPersisted sysPersisted) {
        if (sideLoading && !Sys.allowExternalDescriptors() && !sysPersisted.is(UpmSettings.CONNECT_DEVELOPER_LISTINGS_ENABLED) && !Uris.isFromMpac(uri)) {
            return Option.some("upm.pluginInstall.error.descriptor.not.from.marketplace");
        }
        return Option.none(String.class);
    }
}

