/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.install;

import com.atlassian.upm.HandlerRegistry;
import com.atlassian.upm.api.util.Option;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractConnectHandlerRegistry<T>
implements HandlerRegistry<T>,
DisposableBean {
    private final BundleContext bundleContext;
    private final ImmutableList<T> internalHandlers;
    private Option<ServiceTracker> serviceTracker = Option.none();

    public AbstractConnectHandlerRegistry(BundleContext bundleContext, Set<T> internalHandlers) {
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext, (Object)"bundleContext");
        this.internalHandlers = ImmutableList.copyOf(internalHandlers);
    }

    @Override
    public Iterable<T> getHandlers() {
        ServiceTracker tracker = this.getServiceTracker();
        ImmutableList.Builder ret = ImmutableList.builder();
        for (ServiceReference[] srs : Option.option(tracker.getServiceReferences())) {
            for (ServiceReference sr : srs) {
                if (!this.isAllowableInstallHandler(sr)) continue;
                ret.add(tracker.getService(sr));
            }
        }
        return Iterables.concat(this.internalHandlers, (Iterable)ret.build());
    }

    @Override
    public abstract Class<T> getHandlerClass();

    @VisibleForTesting
    void setServiceTracker(ServiceTracker serviceTracker) {
        for (ServiceTracker t : this.serviceTracker) {
            if (t == serviceTracker) continue;
            t.close();
        }
        this.serviceTracker = Option.some(serviceTracker);
    }

    public void destroy() {
        for (ServiceTracker t : this.serviceTracker) {
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServiceTracker getServiceTracker() {
        Iterator<ServiceTracker> iterator = this.serviceTracker.iterator();
        if (iterator.hasNext()) {
            ServiceTracker st = iterator.next();
            return st;
        }
        iterator = this;
        synchronized (iterator) {
            ServiceTracker tracker = new ServiceTracker(this.bundleContext, this.getHandlerClass().getName(), null);
            tracker.open();
            this.serviceTracker = Option.some(tracker);
            return tracker;
        }
    }

    private boolean isAllowableInstallHandler(ServiceReference sr) {
        return sr.getBundle().getSymbolicName().equals("com.atlassian.plugins.atlassian-connect-plugin");
    }
}

