/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.impl;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.application.api.ApplicationPlugin;
import com.atlassian.application.api.PluginApplication;
import com.atlassian.application.host.plugin.ApplicationMetaDataModuleDescriptor;
import com.atlassian.application.host.plugin.PluginApplicationMetaData;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.upm.api.util.Option;
import com.atlassian.upm.api.util.Pair;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.DisposableBean;

public class UpmAppManagerImpl
implements UpmAppManager,
DisposableBean {
    private final boolean applicationDescriptorExists;
    private final PluginMetadataManager metadata;
    private final Option<ServiceTracker> appMgrServiceTracker;
    private final Option<ServiceTracker> featureMgrServiceTracker;
    private static final Function<ApplicationManager, Option<UpmAppManager.ApplicationInfo>> getAppWithMostActiveUsers = new Function<ApplicationManager, Option<UpmAppManager.ApplicationInfo>>(){

        public Option<UpmAppManager.ApplicationInfo> apply(ApplicationManager manager) {
            Option<Object> max = Option.none();
            for (Application a : manager.getApplications()) {
                if (max.isDefined()) {
                    if (((Application)max.get()).getAccess().getActiveUserCount() >= a.getAccess().getActiveUserCount()) continue;
                    max = Option.some(a);
                    continue;
                }
                max = Option.some(a);
            }
            return max.map(toAppInfo);
        }
    };
    private static final Function<ApplicationManager, Set<String>> getApplicationRelatedPluginKeysFromAppManager = new Function<ApplicationManager, Set<String>>(){

        public Set<String> apply(ApplicationManager manager) {
            HashSet keys = Sets.newHashSet();
            for (Application a : manager.getApplications()) {
                if (!(a instanceof PluginApplication)) continue;
                for (ApplicationPlugin ap : ((PluginApplication)a).getPlugins()) {
                    keys.add(ap.getPluginKey());
                }
            }
            return ImmutableSet.copyOf((Collection)keys);
        }
    };
    private static final Function<Application, UpmAppManager.ApplicationInfo> toAppInfo = new Function<Application, UpmAppManager.ApplicationInfo>(){

        public UpmAppManager.ApplicationInfo apply(Application a) {
            return new UpmAppManager.ApplicationInfo(a.getKey().value(), a.getVersion(), a.getAccess().getActiveUserCount());
        }
    };

    public UpmAppManagerImpl(PluginMetadataManager metadata, BundleContext bundleContext) {
        Option<Object> st2;
        Option<Object> st1;
        this.metadata = (PluginMetadataManager)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        try {
            Class<ApplicationManager> clazz = ApplicationManager.class;
            ServiceTracker t = new ServiceTracker(bundleContext, clazz.getName(), null);
            t.open();
            st1 = Option.some(t);
        }
        catch (NoClassDefFoundError e) {
            st1 = Option.none();
        }
        this.appMgrServiceTracker = st1;
        try {
            Class<DarkFeatureManager> clazz = DarkFeatureManager.class;
            ServiceTracker t = new ServiceTracker(bundleContext, clazz.getName(), null);
            t.open();
            st2 = Option.some(t);
        }
        catch (NoClassDefFoundError e) {
            st2 = Option.none();
        }
        this.featureMgrServiceTracker = st2;
        boolean descriptorExists = false;
        try {
            Class<ApplicationMetaDataModuleDescriptor> clazz = ApplicationMetaDataModuleDescriptor.class;
            descriptorExists = true;
        }
        catch (NoClassDefFoundError e) {
            descriptorExists = false;
        }
        this.applicationDescriptorExists = descriptorExists;
    }

    public void destroy() {
        for (ServiceTracker t : this.appMgrServiceTracker) {
            t.close();
        }
        for (ServiceTracker t : this.featureMgrServiceTracker) {
            t.close();
        }
    }

    @Override
    public boolean isApplicationSupportEnabled() {
        return this.getAppManager().isDefined();
    }

    @Override
    public Option<UpmAppManager.ApplicationInfo> getApplication(String key) {
        if (!this.isApplicationSupportEnabled()) {
            return Option.none();
        }
        return this.getAppManager().flatMap(this.getApp(key));
    }

    @Override
    public Option<UpmAppManager.ApplicationInfo> getApplicationWithMostActiveUsers() {
        if (!this.isApplicationSupportEnabled()) {
            return Option.none();
        }
        return this.getAppManager().flatMap(getAppWithMostActiveUsers);
    }

    @Override
    public Set<String> getApplicationRelatedPluginKeys() {
        if (!this.isApplicationSupportEnabled()) {
            return ImmutableSet.of();
        }
        return this.getAppManager().map(getApplicationRelatedPluginKeysFromAppManager).getOrElse(ImmutableSet.of());
    }

    private Function<ApplicationManager, Option<UpmAppManager.ApplicationInfo>> getApp(final String key) {
        return new Function<ApplicationManager, Option<UpmAppManager.ApplicationInfo>>(){

            public Option<UpmAppManager.ApplicationInfo> apply(ApplicationManager manager) {
                Iterator iterator = manager.getApplication(ApplicationKey.valueOf((String)key)).iterator();
                if (iterator.hasNext()) {
                    Application a = (Application)iterator.next();
                    return Option.some(toAppInfo.apply((Object)a));
                }
                return Option.none();
            }
        };
    }

    @Override
    public boolean isApplication(Plugin plugin) {
        return this.getApplicationKey(plugin).isDefined();
    }

    @Override
    public Option<String> getApplicationKey(Plugin plugin) {
        if (!this.isApplicationSupportEnabled()) {
            return Option.none();
        }
        return this.safeGetAndTransform(plugin, new Function<ModuleDescriptor<?>, String>(){

            public String apply(ModuleDescriptor<?> md) {
                return ((ApplicationMetaDataModuleDescriptor)md).getApplicationKey().value();
            }
        });
    }

    private Iterable<Pair<String, UpmAppManager.ApplicationDescriptorModuleInfo>> getPluginsInApplication(Plugin plugin) {
        return (Iterable)this.safeGetAndTransform(plugin, new Function<ModuleDescriptor<?>, Iterable<Pair<String, UpmAppManager.ApplicationDescriptorModuleInfo>>>(){

            public Iterable<Pair<String, UpmAppManager.ApplicationDescriptorModuleInfo>> apply(ModuleDescriptor<?> md) {
                ApplicationMetaDataModuleDescriptor amd = (ApplicationMetaDataModuleDescriptor)md;
                final String appKey = amd.getApplicationKey().value();
                return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)((PluginApplicationMetaData)amd.getModule()).getPlugins(), (Function)new Function<ApplicationPlugin, Pair<String, UpmAppManager.ApplicationDescriptorModuleInfo>>(){

                    public Pair<String, UpmAppManager.ApplicationDescriptorModuleInfo> apply(ApplicationPlugin p) {
                        UpmAppManager.ApplicationPluginType apt;
                        switch (p.getType()) {
                            case PRIMARY: {
                                apt = UpmAppManager.ApplicationPluginType.PRIMARY;
                                break;
                            }
                            case APPLICATION: {
                                apt = UpmAppManager.ApplicationPluginType.APPLICATION;
                                break;
                            }
                            default: {
                                apt = UpmAppManager.ApplicationPluginType.UTILITY;
                            }
                        }
                        return Pair.pair(p.getPluginKey(), new UpmAppManager.ApplicationDescriptorModuleInfo(appKey, apt));
                    }
                }));
            }
        }).getOrElse(ImmutableList.of());
    }

    @Override
    public Map<String, UpmAppManager.ApplicationDescriptorModuleInfo> getApplicationRelatedPlugins(Iterable<Plugin> plugins) {
        if (!this.isApplicationSupportEnabled()) {
            return ImmutableMap.of();
        }
        HashMap map = Maps.newHashMap();
        for (Plugin plugin : plugins) {
            if (map.containsKey(plugin.getKey()) || !this.metadata.isUserInstalled(plugin)) continue;
            for (Pair<String, UpmAppManager.ApplicationDescriptorModuleInfo> ap : this.getPluginsInApplication(plugin)) {
                map.put(ap.first(), ap.second());
            }
        }
        return ImmutableMap.copyOf((Map)map);
    }

    @Override
    public Function<UpmAppManager.ApplicationDescriptorModuleInfo, String> applicationPluginAppKey() {
        return new Function<UpmAppManager.ApplicationDescriptorModuleInfo, String>(){

            public String apply(UpmAppManager.ApplicationDescriptorModuleInfo ap) {
                return ap.applicationKey;
            }
        };
    }

    @Override
    public Function<UpmAppManager.ApplicationDescriptorModuleInfo, String> applicationPluginTypeString() {
        return new Function<UpmAppManager.ApplicationDescriptorModuleInfo, String>(){

            public String apply(UpmAppManager.ApplicationDescriptorModuleInfo ap) {
                return ap.type.name();
            }
        };
    }

    private Option<ApplicationManager> getAppManager() {
        Iterator<ServiceTracker> iterator = this.appMgrServiceTracker.iterator();
        if (iterator.hasNext()) {
            ServiceTracker t = iterator.next();
            return Option.option((ApplicationManager)t.getService());
        }
        return Option.none();
    }

    private <T> Option<T> safeGetAndTransform(Plugin plugin, Function<ModuleDescriptor<?>, T> f) {
        if (this.applicationDescriptorExists) {
            for (ModuleDescriptor md : plugin.getModuleDescriptors()) {
                if (!(md instanceof ApplicationMetaDataModuleDescriptor)) continue;
                return Option.some(f.apply((Object)md));
            }
        }
        return Option.none();
    }
}

