/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.impl;

import com.atlassian.upm.UpmPluginAccessor;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginMetadataAccessor;
import com.atlassian.upm.core.PluginRetriever;
import com.atlassian.upm.core.PluginsEnablementState;
import com.atlassian.upm.core.PluginsEnablementStateAccessor;
import com.atlassian.upm.core.SafeModeAccessor;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;

public class SafeModeAccessorImpl
implements SafeModeAccessor {
    protected final UpmPluginAccessor pluginAccessor;
    private final PluginRetriever pluginRetriever;
    protected final PluginMetadataAccessor metadata;
    private final PluginsEnablementStateAccessor enablementStateAccessor;

    public SafeModeAccessorImpl(UpmPluginAccessor pluginAccessor, PluginRetriever pluginRetriever, PluginMetadataAccessor metadata, PluginsEnablementStateAccessor enablementStateAccessor) {
        this.pluginAccessor = (UpmPluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor, (Object)"pluginAccessor");
        this.pluginRetriever = (PluginRetriever)Preconditions.checkNotNull((Object)pluginRetriever, (Object)"pluginRetriever");
        this.metadata = (PluginMetadataAccessor)Preconditions.checkNotNull((Object)metadata, (Object)"metadata");
        this.enablementStateAccessor = (PluginsEnablementStateAccessor)Preconditions.checkNotNull((Object)enablementStateAccessor, (Object)"enablementStateAccessor");
    }

    @Override
    public boolean isSafeMode() {
        return this.enablementStateAccessor.hasSavedConfiguration();
    }

    @Override
    public PluginsEnablementState getCurrentConfiguration() {
        return this.getCurrentConfiguration(this.pluginRetriever.getPlugins());
    }

    protected PluginsEnablementState getCurrentConfiguration(Iterable<Plugin> plugins) {
        return new PluginsEnablementState.Builder(this.transformPluginToPluginConfigurations(plugins), this.pluginRetriever, this.metadata).title("Current Configuration").build();
    }

    protected Iterable<PluginsEnablementState.PluginState> transformPluginToPluginConfigurations(Iterable<Plugin> plugins) {
        return ImmutableList.copyOf((Iterable)Iterables.transform(plugins, (Function)new Function<Plugin, PluginsEnablementState.PluginState>(){

            public PluginsEnablementState.PluginState apply(Plugin plugin) {
                return new PluginsEnablementState.PluginState.Builder(plugin, SafeModeAccessorImpl.this.pluginAccessor).build();
            }
        }));
    }
}

