/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.core.impl;

import com.atlassian.upm.core.HostApplicationDescriptor;
import com.atlassian.upm.core.impl.UpmAppManager;
import com.atlassian.upm.core.test.rest.resources.ActiveEditionResource;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;

public class AbstractApplicationDescriptor
implements HostApplicationDescriptor {
    private final UpmAppManager upmAppManager;
    private final Supplier<Integer> activeUserCount;
    private static final Function<UpmAppManager.ApplicationInfo, Integer> numberOfActiveUsers = new Function<UpmAppManager.ApplicationInfo, Integer>(){

        public Integer apply(UpmAppManager.ApplicationInfo app) {
            return app.numberOfActiveUsers;
        }
    };

    public AbstractApplicationDescriptor(UpmAppManager upmAppManager, Supplier<Integer> activeUserCount) {
        this.upmAppManager = (UpmAppManager)Preconditions.checkNotNull((Object)upmAppManager, (Object)"upmAppManager");
        this.activeUserCount = (Supplier)Preconditions.checkNotNull(activeUserCount, (Object)"activeUserCount");
    }

    @Override
    public int getActiveEditionCount() {
        return this.getActiveUserCount();
    }

    @Override
    public int getActiveUserCount() {
        return ActiveEditionResource.getActiveEdition().orElse(this.upmAppManager.getApplicationWithMostActiveUsers().map(numberOfActiveUsers)).getOrElse(this.activeUserCount);
    }
}

