/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.servlet;

import com.atlassian.upm.application.servlet.ApplicationManagerHandler;
import com.atlassian.upm.core.analytics.AnalyticsLogger;
import com.atlassian.upm.core.analytics.event.DefaultAnalyticsEvent;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.atlassian.upm.core.servlet.UpmServletHandler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ManageApplicationServlet
extends HttpServlet {
    private final AnalyticsLogger analyticsLogger;
    private final ApplicationManagerHandler handler;
    private final PermissionEnforcer permissionEnforcer;

    public ManageApplicationServlet(AnalyticsLogger analyticsLogger, ApplicationManagerHandler handler, PermissionEnforcer permissionEnforcer) {
        this.analyticsLogger = (AnalyticsLogger)Preconditions.checkNotNull((Object)analyticsLogger, (Object)"analyticsLogger");
        this.handler = (ApplicationManagerHandler)Preconditions.checkNotNull((Object)handler, (Object)"handler");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.permissionEnforcer.hasPermission(Permission.GET_APPLICATIONS)) {
            this.handler.redirectToLogin(request, response, UpmServletHandler.PermissionLevel.ADMIN);
            return;
        }
        this.analyticsLogger.log(new DefaultAnalyticsEvent("manageapps-page"));
        this.handler.handle(request, response, "manage-applications.vm", true);
    }
}

