/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.marketplace;

import com.atlassian.application.api.Application;
import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CompatibilityCacheFactory;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Eithers;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Options;
import com.atlassian.fugue.Pair;
import com.atlassian.marketplace.client.MarketplaceClient;
import com.atlassian.marketplace.client.MpacException;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.HostingType;
import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.api.ProductQuery;
import com.atlassian.marketplace.client.api.ProductVersionSpecifier;
import com.atlassian.marketplace.client.model.Product;
import com.atlassian.marketplace.client.model.ProductVersion;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.executor.ThreadLocalDelegateExecutorFactory;
import com.atlassian.upm.SysPersisted;
import com.atlassian.upm.UpmSettings;
import com.atlassian.upm.application.impl.ApplicationAccessor;
import com.atlassian.upm.application.impl.ApplicationUtil;
import com.atlassian.upm.application.marketplace.AppUpdateInfo;
import com.atlassian.upm.application.marketplace.ApplicationMarketplaceQueries;
import com.atlassian.upm.application.marketplace.MarketplaceResult;
import com.atlassian.upm.application.marketplace.PlatformVersionInfo;
import com.atlassian.upm.core.VersionAwareHostApplicationInformation;
import com.atlassian.upm.core.pac.MarketplaceBaseUrlChangedEvent;
import com.atlassian.upm.core.pac.MarketplaceClientManager;
import com.atlassian.upm.core.pac.PlatformBuildNumberChangeEvent;
import com.atlassian.upm.osgi.impl.Versions;
import com.atlassian.util.concurrent.AsyncCompleter;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class ApplicationMarketplaceQueriesImpl
implements ApplicationMarketplaceQueries,
DisposableBean,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationMarketplaceQueriesImpl.class);
    private static final int MAX_THREADS = 8;
    private final ApplicationAccessor applicationAccessor;
    private final ApplicationProperties applicationProperties;
    private final VersionAwareHostApplicationInformation hostApplicationInformation;
    private final EventPublisher eventPublisher;
    private final MarketplaceClientManager marketplaceClientFactory;
    private final SysPersisted sysPersisted;
    private final ExecutorService executorService;
    private final AsyncCompleter completer;
    private Cache<Integer, PlatformVersionInfo> platformVersionInfoCache;

    public ApplicationMarketplaceQueriesImpl(ApplicationAccessor applicationAccessor, ApplicationProperties applicationProperties, VersionAwareHostApplicationInformation hostApplicationInformation, EventPublisher eventPublisher, MarketplaceClientManager marketplaceClientFactory, SysPersisted sysPersisted, ThreadLocalDelegateExecutorFactory threadLocalDelegateExecutorFactory, CompatibilityCacheFactory cacheFactory) {
        this.applicationAccessor = (ApplicationAccessor)Preconditions.checkNotNull((Object)applicationAccessor, (Object)"applicationAccessor");
        this.applicationProperties = (ApplicationProperties)Preconditions.checkNotNull((Object)applicationProperties, (Object)"applicationProperties");
        this.hostApplicationInformation = (VersionAwareHostApplicationInformation)Preconditions.checkNotNull((Object)hostApplicationInformation, (Object)"hostApplicationInformation");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
        this.marketplaceClientFactory = (MarketplaceClientManager)Preconditions.checkNotNull((Object)marketplaceClientFactory, (Object)"marketplaceClientFactory");
        this.sysPersisted = (SysPersisted)Preconditions.checkNotNull((Object)sysPersisted, (Object)"sysPersisted");
        this.executorService = threadLocalDelegateExecutorFactory.createExecutorService(Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory("ApplicationMarketplaceQueries:")));
        this.completer = new AsyncCompleter.Builder(this.executorService).limitParallelExecutionTo(8);
        this.platformVersionInfoCache = cacheFactory.getCache("ApplicationMarketplaceQueries.platformVersionInfo", new PlatformVersionInfoLoader(), new CacheSettingsBuilder().local().expireAfterWrite(4L, TimeUnit.HOURS).build());
    }

    public void afterPropertiesSet() {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() {
        this.eventPublisher.unregister((Object)this);
    }

    @Override
    public PlatformVersionInfo getPlatformVersionInfo() {
        return this.platformVersionInfoCache.get(this.hostApplicationInformation.getBuildNumber());
    }

    @Override
    public MarketplaceResult<Iterable<Product>> getAvailableAppsInfo(boolean withPlatform, Option<Integer> platformBuildNumber) {
        if (this.isMpacDisabled()) {
            return MarketplaceResult.disabled();
        }
        PlatformVersionInfo pvi = this.getPlatformVersionInfo();
        if (!platformBuildNumber.isDefined() && pvi.isDefinitelyUnknownToMarketplace()) {
            return MarketplaceResult.success(ImmutableList.of());
        }
        final int platformBuildNumberToQuery = (Integer)platformBuildNumber.getOrElse((Object)pvi.buildNumber);
        final MarketplaceClient mpacClient = this.getClient();
        Callable<Either<MpacException, Either<Iterable<Product>, Option<Product>>>> availableAppsQueryTask = new Callable<Either<MpacException, Either<Iterable<Product>, Option<Product>>>>(){

            @Override
            public Either<MpacException, Either<Iterable<Product>, Option<Product>>> call() throws Exception {
                try {
                    ProductQuery query = ApplicationMarketplaceQueriesImpl.this.getProductCriteria(platformBuildNumberToQuery).withVersion(true).build();
                    Page<Product> products = mpacClient.products().find(query);
                    return Either.right((Object)Either.left(products));
                }
                catch (MpacException e) {
                    return Either.left((Object)e);
                }
            }
        };
        Callable<Either<MpacException, Either<Iterable<Product>, Option<Product>>>> platformQueryTask = new Callable<Either<MpacException, Either<Iterable<Product>, Option<Product>>>>(){

            @Override
            public Either<MpacException, Either<Iterable<Product>, Option<Product>>> call() throws Exception {
                try {
                    ProductQuery query = ProductQuery.builder().withVersion(true).build();
                    Option<Product> product = mpacClient.products().getByKey(ApplicationMarketplaceQueriesImpl.this.getApplicationKey().getKey(), query);
                    return Either.right((Object)Either.right(product));
                }
                catch (MpacException e) {
                    return Either.left((Object)e);
                }
            }
        };
        Iterable results = this.completer.invokeAll(withPlatform ? ImmutableList.of((Object)availableAppsQueryTask, (Object)platformQueryTask) : ImmutableList.of((Object)availableAppsQueryTask));
        Iterator iterator = Eithers.filterLeft(results).iterator();
        if (iterator.hasNext()) {
            MpacException e = (MpacException)iterator.next();
            logger.warn("Marketplace product query failed: " + e);
            logger.debug(e.toString(), (Throwable)e);
            return MarketplaceResult.unreachable();
        }
        Iterable apps = (Iterable)Options.find((Iterable)Iterables.transform((Iterable)Eithers.filterRight(results), (Function)Eithers.leftMapper())).getOrElse((Object)ImmutableList.of());
        Option platform = (Option)Options.find((Iterable)Iterables.transform((Iterable)Eithers.filterRight(results), (Function)Eithers.rightMapper())).getOrElse((Object)Option.none());
        return MarketplaceResult.success(Iterables.concat((Iterable)apps, (Iterable)platform));
    }

    @Override
    public MarketplaceResult<Iterable<AppUpdateInfo>> getAppUpdateInfo(final int targetPlatformBuildNumber, Iterable<Application> installedApps) {
        MarketplaceResult mpacInfoForCurrentApps = this.getMpacVersionInfo(installedApps);
        MarketplaceResult mpacInfoForTarget = this.getAvailableAppsInfo(false, (Option<Integer>)Option.some((Object)targetPlatformBuildNumber));
        if (mpacInfoForCurrentApps.mpacDisabled || mpacInfoForTarget.mpacDisabled) {
            return MarketplaceResult.disabled();
        }
        if (mpacInfoForCurrentApps.mpacUnreachable || mpacInfoForTarget.mpacUnreachable) {
            return MarketplaceResult.unreachable();
        }
        Map installedVersionsByKey = Maps.transformValues((Map)Maps.uniqueIndex(MarketplaceResult.listFromResult(mpacInfoForCurrentApps), (Function)Pair.leftValue()), (Function)Pair.rightValue());
        ImmutableMap mpacUpdatesByKey = Maps.uniqueIndex(MarketplaceResult.listFromResult(mpacInfoForTarget), ApplicationUtil.productProductKey());
        ImmutableList.Builder ret = ImmutableList.builder();
        final ApplicationKey applicationKey = this.getApplicationKey();
        for (Application installedApp : installedApps) {
            String key = installedApp.getKey().value();
            String installedVer = this.applicationAccessor.getInstalledVersion(installedApp);
            Option installedMpacVer = Option.option(installedVersionsByKey.get(key));
            for (Product newProduct : Option.option(mpacUpdatesByKey.get(key))) {
                for (ProductVersion newVer : newProduct.getVersion()) {
                    try {
                        if (Versions.fromString(newVer.getName()).compareTo(Versions.fromString(installedVer)) <= 0) continue;
                        boolean oldVersionWasIncompatible = installedMpacVer.exists((Predicate)new Predicate<ProductVersion>(){

                            public boolean apply(ProductVersion v) {
                                return !v.isCompatibleWith(applicationKey, HostingType.SERVER, targetPlatformBuildNumber);
                            }
                        });
                        ret.add((Object)new AppUpdateInfo(newProduct, newVer, installedVer, oldVersionWasIncompatible));
                    }
                    catch (IllegalArgumentException e) {
                        logger.warn("Unable to compare available version \"" + newVer.getName() + "\" to installed version \"" + installedVer + "\" due to bad version string format: " + e);
                    }
                }
            }
        }
        return MarketplaceResult.success(ret.build());
    }

    @Override
    public Option<Product> getProductWithLatestVersion(String applicationKey) {
        PlatformVersionInfo pvi;
        if (!this.isMpacDisabled() && !(pvi = this.getPlatformVersionInfo()).isDefinitelyUnknownToMarketplace()) {
            ProductQuery query = this.getProductCriteria(pvi.buildNumber).withVersion(true).build();
            try {
                return this.getClient().products().getByKey(applicationKey, query);
            }
            catch (MpacException e) {
                logger.warn("Marketplace product query failed: " + e);
            }
        }
        return Option.none();
    }

    @Override
    public MarketplaceResult<Map<String, ProductVersion>> getMpacVersionInfoForInstalledApps(Iterable<Application> apps) {
        if (this.isMpacDisabled()) {
            return MarketplaceResult.disabled();
        }
        MarketplaceResult<Iterable<Pair<String, ProductVersion>>> versionInfo = this.getMpacVersionInfo(apps);
        if (!versionInfo.mpacUnreachable) {
            HashMap<Object, Object> versions = new HashMap<Object, Object>();
            for (Iterable result : versionInfo.value) {
                for (Pair p : result) {
                    versions.put(p.left(), p.right());
                }
            }
            return MarketplaceResult.success(versions);
        }
        return MarketplaceResult.unreachable();
    }

    @Override
    public Option<ProductVersion> getMpacVersionInfoForInstalledApp(Application app) {
        MarketplaceResult<Map<String, ProductVersion>> result = this.getMpacVersionInfoForInstalledApps((Iterable<Application>)ImmutableList.of((Object)app));
        if (result.mpacUnreachable || result.mpacDisabled) {
            return Option.none();
        }
        Iterator iterator = result.value.iterator();
        if (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            return Option.option(map.get(app.getKey().value()));
        }
        return Option.none();
    }

    @EventListener
    public void onPlatformBuildNumberChangeEvent(PlatformBuildNumberChangeEvent event) {
        this.platformVersionInfoCache.removeAll();
    }

    @EventListener
    public void onMarketplaceBaseUrlChangedEvent(MarketplaceBaseUrlChangedEvent event) {
        this.platformVersionInfoCache.removeAll();
    }

    private MarketplaceClient getClient() {
        return this.marketplaceClientFactory.getMarketplaceClient();
    }

    private ProductQuery.Builder getProductCriteria(int platformBuildNumber) {
        return ((ProductQuery.Builder)((ProductQuery.Builder)ProductQuery.builder().application(Option.some((Object)this.getApplicationKey()))).appBuildNumber(Option.some((Object)platformBuildNumber))).hosting(Option.some((Object)HostingType.SERVER));
    }

    private ApplicationKey getApplicationKey() {
        return ApplicationKey.valueOf(this.applicationProperties.getDisplayName());
    }

    private boolean isMpacDisabled() {
        return this.sysPersisted.is(UpmSettings.PAC_DISABLED);
    }

    private MarketplaceResult<Iterable<Pair<String, ProductVersion>>> getMpacVersionInfo(Iterable<Application> apps) {
        if (this.isMpacDisabled()) {
            return MarketplaceResult.disabled();
        }
        final MarketplaceClient client = this.getClient();
        Iterable callables = Iterables.transform(apps, (Function)new Function<Application, Callable<MarketplaceResult<Pair<String, Option<ProductVersion>>>>>(){

            public Callable<MarketplaceResult<Pair<String, Option<ProductVersion>>>> apply(final Application app) {
                return new Callable<MarketplaceResult<Pair<String, Option<ProductVersion>>>>(){

                    @Override
                    public MarketplaceResult<Pair<String, Option<ProductVersion>>> call() throws Exception {
                        String verName = ApplicationMarketplaceQueriesImpl.this.applicationAccessor.getInstalledVersion(app);
                        try {
                            String key = app.getKey().value();
                            Option<ProductVersion> result = client.products().getVersion(key, ProductVersionSpecifier.name(verName));
                            return MarketplaceResult.success(Pair.pair((Object)key, result));
                        }
                        catch (MpacException e) {
                            return MarketplaceResult.unreachable();
                        }
                    }
                };
            }
        });
        Iterable results = this.completer.invokeAll(callables);
        for (MarketplaceResult r : results) {
            if (!r.mpacUnreachable) continue;
            return MarketplaceResult.unreachable();
        }
        ImmutableList.Builder ret = ImmutableList.builder();
        for (MarketplaceResult r : results) {
            for (Pair p : r.value) {
                for (ProductVersion v : (Option)p.right()) {
                    ret.add((Object)Pair.pair((Object)p.left(), (Object)v));
                }
            }
        }
        return MarketplaceResult.success(ret.build());
    }

    private class PlatformVersionInfoLoader
    implements CacheLoader<Integer, PlatformVersionInfo> {
        private PlatformVersionInfoLoader() {
        }

        @Override
        public PlatformVersionInfo load(Integer buildNumber) {
            boolean devVersion = ApplicationMarketplaceQueriesImpl.this.hostApplicationInformation.isDevelopmentProductVersion();
            if (ApplicationMarketplaceQueriesImpl.this.isMpacDisabled()) {
                return new PlatformVersionInfo(buildNumber, devVersion, (Option<Boolean>)Option.none(Boolean.class));
            }
            String key = ApplicationMarketplaceQueriesImpl.this.getApplicationKey().getKey();
            try {
                if (ApplicationMarketplaceQueriesImpl.this.getClient().products().getVersion(key, ProductVersionSpecifier.buildNumber(buildNumber)).isDefined()) {
                    return new PlatformVersionInfo(buildNumber, devVersion, (Option<Boolean>)Option.some((Object)true));
                }
                if (devVersion) {
                    for (Product p : ApplicationMarketplaceQueriesImpl.this.getClient().products().getByKey(key, ProductQuery.builder().withVersion(true).build())) {
                        Iterator iterator = p.getVersion().iterator();
                        if (!iterator.hasNext()) continue;
                        ProductVersion v = (ProductVersion)iterator.next();
                        return new PlatformVersionInfo(v.getBuildNumber(), devVersion, (Option<Boolean>)Option.some((Object)false));
                    }
                }
                return new PlatformVersionInfo(buildNumber, devVersion, (Option<Boolean>)Option.some((Object)false));
            }
            catch (MpacException e) {
                return new PlatformVersionInfo(buildNumber, devVersion, (Option<Boolean>)Option.none(Boolean.class));
            }
        }
    }
}

