/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.impl;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationPlugin;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.marketplace.client.model.Product;
import com.atlassian.marketplace.client.model.ProductVersion;
import com.atlassian.upm.application.rest.representations.ApplicationRepresentationFactory;
import com.atlassian.upm.application.rest.representations.AvailableAppRepresentation;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class ApplicationUtil {
    public static Comparator<Application> applicationSorter = new Comparator<Application>(){

        @Override
        public int compare(Application app1, Application app2) {
            if (app1 instanceof PlatformApplication) {
                return 1;
            }
            if (app2 instanceof PlatformApplication) {
                return -1;
            }
            return app1.getName().compareTo(app2.getName());
        }
    };

    public static Function<Application, String> applicationKey() {
        return new Function<Application, String>(){

            public String apply(Application application) {
                return application.getKey().value();
            }
        };
    }

    public static Function<ApplicationPlugin, String> applicationPluginKey() {
        return new Function<ApplicationPlugin, String>(){

            public String apply(ApplicationPlugin p) {
                return p.getPluginKey();
            }
        };
    }

    public static Predicate<Product> productAlreadyInstalled(Iterable<Application> installedApps) {
        ImmutableSet installedKeys = ImmutableSet.copyOf((Iterable)Iterables.transform(installedApps, (Function)new Function<Application, String>(){

            public String apply(Application application) {
                return application.getKey().toString();
            }
        }));
        return new Predicate<Product>((Set)installedKeys){
            final /* synthetic */ Set val$installedKeys;
            {
                this.val$installedKeys = set;
            }

            public boolean apply(Product p) {
                return this.val$installedKeys.contains(p.getKey());
            }
        };
    }

    public static Predicate<Product> productAlreadyInstalledWithSameVersion(final Map<String, String> installedAppVersions) {
        return new Predicate<Product>(){

            public boolean apply(Product p) {
                Iterator iterator = p.getVersion().iterator();
                if (iterator.hasNext()) {
                    ProductVersion v = (ProductVersion)iterator.next();
                    return v.getName().equals(installedAppVersions.get(p.getKey()));
                }
                return false;
            }
        };
    }

    public static Predicate<Product> productHasProductKey(String key) {
        return Predicates.compose((Predicate)Predicates.equalTo((Object)key), ApplicationUtil.productProductKey());
    }

    public static Function<Product, String> productProductKey() {
        return new Function<Product, String>(){

            public String apply(Product input) {
                return input.getKey();
            }
        };
    }

    public static Function<Product, AvailableAppRepresentation> toAvailableAppRepresentation(final ApplicationRepresentationFactory factory) {
        return new Function<Product, AvailableAppRepresentation>(){

            public AvailableAppRepresentation apply(Product product) {
                return factory.createAvailableAppRepresentation(product);
            }
        };
    }
}

