/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.impl;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationManager;
import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.i18n.InvalidOperationException;
import com.atlassian.sal.api.license.LicenseHandler;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.validate.ValidationResult;
import com.atlassian.upm.application.impl.ApplicationUriBuilder;
import com.atlassian.upm.core.actionresult.ActionResult;
import com.atlassian.upm.core.actionresult.ActionResultCollection;
import com.atlassian.upm.core.analytics.AnalyticsLogger;
import com.atlassian.upm.core.analytics.event.DefaultAnalyticsEvent;
import com.atlassian.upm.core.impl.Uris;
import com.atlassian.upm.core.permission.Permission;
import com.atlassian.upm.core.rest.resources.permission.PermissionEnforcer;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLicenseReceiptHandler {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLicenseReceiptHandler.class);
    private final ApplicationManager applicationManager;
    private final LicenseHandler licenseHandler;
    private final LocaleResolver localeResolver;
    private final I18nResolver i18nResolver;
    private final PermissionEnforcer permissionEnforcer;
    private final ApplicationUriBuilder uriBuilder;
    private final AnalyticsLogger analyticsLogger;
    private final String EVAL_LICENSE_FRAGMENT = "evaluation";

    public ApplicationLicenseReceiptHandler(ApplicationManager applicationManager, LicenseHandler licenseHandler, LocaleResolver localeResolver, I18nResolver i18nResolver, PermissionEnforcer permissionEnforcer, ApplicationUriBuilder uriBuilder, AnalyticsLogger analyticsLogger) {
        this.applicationManager = (ApplicationManager)Preconditions.checkNotNull((Object)applicationManager, (Object)"applicationManager");
        this.licenseHandler = (LicenseHandler)Preconditions.checkNotNull((Object)licenseHandler, (Object)"licenseHandler");
        this.localeResolver = (LocaleResolver)Preconditions.checkNotNull((Object)localeResolver, (Object)"localeResolver");
        this.i18nResolver = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.permissionEnforcer = (PermissionEnforcer)Preconditions.checkNotNull((Object)permissionEnforcer, (Object)"permissionEnforcer");
        this.uriBuilder = (ApplicationUriBuilder)Preconditions.checkNotNull((Object)uriBuilder, (Object)"uriBuilder");
        this.analyticsLogger = (AnalyticsLogger)Preconditions.checkNotNull((Object)analyticsLogger, (Object)"analyticsLogger");
    }

    public Either<RequestError, ActionResultCollection> handle(final HttpServletRequest request) {
        return this.validateInitial(request).right().map((Function)new Function<Iterable<String>, ActionResultCollection>(){

            public ActionResultCollection apply(Iterable<String> licenseKVs) {
                boolean addedError = false;
                ImmutableList.Builder resultsBuilder = ImmutableList.builder();
                for (String licenseKV : licenseKVs) {
                    ActionResult res = ApplicationLicenseReceiptHandler.this.handleLicense(licenseKV, request);
                    if (res.getType().equals((Object)ActionResult.ActionResultType.ERROR)) {
                        if (!addedError) {
                            resultsBuilder.add((Object)res);
                        }
                        addedError = true;
                        continue;
                    }
                    resultsBuilder.add((Object)res);
                }
                return new ActionResultCollection((Iterable<ActionResult>)resultsBuilder.build());
            }
        });
    }

    private Either<RequestError, Iterable<String>> validateInitial(HttpServletRequest request) {
        Object[] licenseParam = request.getParameterValues("license");
        if (licenseParam == null) {
            return Either.left((Object)((Object)RequestError.BAD_REFERRER));
        }
        ImmutableList licenses = ImmutableList.copyOf((Object[])licenseParam);
        if (licenses.isEmpty()) {
            return Either.left((Object)((Object)RequestError.BAD_REFERRER));
        }
        String referrer = request.getHeader("Referer");
        if (referrer != null && !Uris.isAtlassianURI(URI.create(referrer))) {
            log.warn("Refused a request that had an unexpected referrer: " + referrer);
            return Either.left((Object)((Object)RequestError.BAD_REFERRER));
        }
        if (!this.hasPermission()) {
            log.warn("Unable to store new licenses: not logged in as an administrator");
            return Either.left((Object)((Object)RequestError.NOT_AUTHENTICATED));
        }
        return Either.right((Object)licenses);
    }

    private boolean isEvaluationLicense(HttpServletRequest request) {
        return Option.option((Object)request.getPathInfo()).exists((Predicate)new Predicate<String>(){

            public boolean apply(String pathInfo) {
                return pathInfo.endsWith("evaluation");
            }
        });
    }

    private String getAppKeyPathParam(HttpServletRequest request) {
        String[] fragments = request.getPathInfo().split("\\/");
        return fragments[fragments.length - 2];
    }

    private ActionResult handleLicense(String licenseFieldValue, HttpServletRequest request) {
        String license;
        ImmutableMap analyticsMeta;
        ApplicationKey applicationKey;
        String[] split = licenseFieldValue.split("\\|");
        boolean isEvaluationLicense = this.isEvaluationLicense(request);
        try {
            applicationKey = ApplicationKey.valueOf((String)(isEvaluationLicense ? this.getAppKeyPathParam(request) : split[0]));
            analyticsMeta = ImmutableMap.of((Object)"appKey", (Object)applicationKey.value());
        }
        catch (IllegalArgumentException iax) {
            return this.getErrorActionResult();
        }
        try {
            license = isEvaluationLicense ? licenseFieldValue : split[1];
        }
        catch (ArrayIndexOutOfBoundsException iob) {
            this.logRejection(applicationKey.value(), "license string not present");
            this.analyticsLogger.log(new DefaultAnalyticsEvent("manageapps-postback-license-failure-missing", (Map<String, String>)analyticsMeta));
            return this.getErrorActionResult();
        }
        ValidationResult validationResult = this.licenseHandler.validateProductLicense(applicationKey.value(), license, this.localeResolver.getLocale(request));
        if (validationResult.hasErrors()) {
            for (String error : validationResult.getErrorMessages()) {
                this.logRejection(applicationKey.value(), error);
                this.analyticsLogger.log(new DefaultAnalyticsEvent("manageapps-postback-license-failure-error", (Map<String, String>)analyticsMeta));
            }
            return this.getErrorActionResult();
        }
        boolean previouslyLicensed = Option.option((Object)this.licenseHandler.getProductLicenseDetails(applicationKey.value())).isDefined();
        try {
            this.licenseHandler.addProductLicense(applicationKey.value(), license);
        }
        catch (IllegalArgumentException iax) {
            this.logRejection(applicationKey.value(), "license not valid");
            this.analyticsLogger.log(new DefaultAnalyticsEvent("manageapps-postback-license-failure-invalid", (Map<String, String>)analyticsMeta));
            return new ActionResult(ActionResult.ActionResultType.WARNING, this.i18nResolver.getText("upm.applications.notifications.flag.licensed.warning.different.application"));
        }
        catch (InvalidOperationException e) {
            this.logRejection(applicationKey.value(), e.getMessage());
            this.analyticsLogger.log(new DefaultAnalyticsEvent("manageapps-postback-license-failure-invalid", (Map<String, String>)analyticsMeta));
            return this.getErrorActionResult();
        }
        if (validationResult.hasWarnings()) {
            for (String warning : validationResult.getWarningMessages()) {
                this.logRejection(applicationKey.value(), warning);
                this.analyticsLogger.log(new DefaultAnalyticsEvent("manageapps-postback-license-failure-warning", (Map<String, String>)analyticsMeta));
            }
            return new ActionResult(ActionResult.ActionResultType.WARNING, this.i18nResolver.getText("upm.applications.notifications.flag.licensed.warning.validation"));
        }
        Iterator iterator = this.applicationManager.getApplication(applicationKey).iterator();
        if (iterator.hasNext()) {
            Application application = (Application)iterator.next();
            Option<String> getStartedLink = Option.none();
            if (!previouslyLicensed) {
                getStartedLink = this.getAnchorTag(this.uriBuilder.buildPostInstallUri(application), (Option<String>)Option.none(String.class), this.i18nResolver.getText("upm.applications.notifications.action.get.started"));
            }
            this.analyticsLogger.log(new DefaultAnalyticsEvent("manageapps-postback-license-success", (Map<String, String>)analyticsMeta));
            return new ActionResult(ActionResult.ActionResultType.SUCCESS, this.i18nResolver.getText("upm.applications.notifications.flag.licensed.success", new Serializable[]{application.getName(), (Serializable)getStartedLink.getOrElse((Object)"")}));
        }
        this.analyticsLogger.log(new DefaultAnalyticsEvent("manageapps-postback-license-success-but-not-installed", (Map<String, String>)analyticsMeta));
        return new ActionResult(ActionResult.ActionResultType.WARNING, this.i18nResolver.getText("upm.applications.notifications.flag.licensed.warning.not.yet.installed"));
    }

    private ActionResult getErrorActionResult() {
        return new ActionResult(ActionResult.ActionResultType.ERROR, this.i18nResolver.getText("upm.applications.notifications.flag.licensed.error.invalid"));
    }

    private Option<String> getAnchorTag(Option<URI> href, final Option<String> applicationKey, final String label) {
        return href.map((Function)new Function<URI, String>(){

            public String apply(URI h) {
                String tag = "<a class=\"no-line-wrap\" href=\"" + h.toASCIIString() + "\" ";
                for (String appKey : applicationKey) {
                    tag = tag + "data-applicationKey=\"" + appKey + "\"";
                }
                tag = tag + ">" + label + "</a>";
                return tag;
            }
        });
    }

    private boolean hasPermission() {
        return this.permissionEnforcer.isLoggedIn() && this.permissionEnforcer.hasPermission(Permission.MANAGE_APPLICATION_LICENSES);
    }

    private void logRejection(String pluginKey, String errorDescription) {
        log.warn("Unable to store new license for \"" + pluginKey + "\": " + errorDescription);
    }

    public static enum RequestError {
        NOT_AUTHENTICATED,
        BAD_REFERRER;

    }
}

