/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.upm.application.impl;

import com.atlassian.application.api.Application;
import com.atlassian.application.api.PlatformApplication;
import com.atlassian.application.api.PluginApplication;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.upm.PluginMetadata;
import com.atlassian.upm.UpmFugueConverters;
import com.atlassian.upm.application.impl.ApplicationAccessor;
import com.atlassian.upm.application.impl.ApplicationUtil;
import com.atlassian.upm.application.rest.representations.ApplicationPluginRepresentation;
import com.atlassian.upm.core.Plugin;
import com.atlassian.upm.core.PluginRetriever;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Map;
import org.joda.time.DateTime;

public class ApplicationAccessorImpl
implements ApplicationAccessor {
    private final ApplicationProperties applicationProperties;
    private final PluginRetriever pluginRetriever;

    public ApplicationAccessorImpl(ApplicationProperties applicationProperties, PluginRetriever pluginRetriever) {
        this.applicationProperties = applicationProperties;
        this.pluginRetriever = pluginRetriever;
    }

    @Override
    public DateTime getBuildDate(Application app) {
        for (Plugin plugin : this.getApplicationPlugin(app)) {
            Iterator<DateTime> iterator = PluginMetadata.getPluginBuildDate(com.atlassian.upm.api.util.Option.some(plugin.getPlugin())).iterator();
            if (!iterator.hasNext()) continue;
            DateTime buildDate = iterator.next();
            return buildDate;
        }
        return new DateTime((Object)this.applicationProperties.getBuildDate());
    }

    @Override
    public String getInstalledVersion(Application app) {
        return app.getVersion();
    }

    @Override
    public Map<ApplicationPluginRepresentation.ApplicationPluginType, Iterable<String>> getPluginKeys(Application app) {
        ImmutableMap.Builder ret = ImmutableMap.builder();
        if (app instanceof PluginApplication) {
            PluginApplication pluginApp = (PluginApplication)app;
            ret.put((Object)ApplicationPluginRepresentation.ApplicationPluginType.PRIMARY, (Object)ImmutableList.of((Object)pluginApp.getPrimaryPlugin().getPluginKey()));
            ret.put((Object)ApplicationPluginRepresentation.ApplicationPluginType.APPLICATION, (Object)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)pluginApp.getApplicationPlugins(), ApplicationUtil.applicationPluginKey())));
            ret.put((Object)ApplicationPluginRepresentation.ApplicationPluginType.UTILITY, (Object)ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)pluginApp.getUtilityPlugins(), ApplicationUtil.applicationPluginKey())));
        }
        return ret.build();
    }

    @Override
    public Option<String> getPrimaryPluginKey(Application app) {
        if (app instanceof PluginApplication) {
            return Option.some((Object)((PluginApplication)app).getPrimaryPlugin().getPluginKey());
        }
        return Option.none();
    }

    @Override
    public boolean isPlatform(Application app) {
        return app instanceof PlatformApplication;
    }

    private Option<Plugin> getApplicationPlugin(Application app) {
        Iterator iterator = this.getPrimaryPluginKey(app).iterator();
        if (iterator.hasNext()) {
            String key = (String)iterator.next();
            return UpmFugueConverters.toFugueOption(this.pluginRetriever.getPlugin(key));
        }
        return Option.none();
    }
}

