/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.model;

import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.HostingType;
import com.google.common.base.Predicate;
import java.util.Iterator;

public final class VersionCompatibility {
    ApplicationKey application;
    CompatibilityHosting hosting;

    VersionCompatibility(ApplicationKey application, CompatibilityHosting hosting) {
        this.application = application;
        this.hosting = hosting;
    }

    public ApplicationKey getApplication() {
        return this.application;
    }

    public boolean isCloudCompatible() {
        return this.hosting.isCloudCompatible();
    }

    public boolean isServerCompatible() {
        return this.hosting.isServerCompatible();
    }

    public Option<Pair<Integer, Integer>> getServerBuildRange() {
        Iterator i$ = this.hosting.server.iterator();
        if (i$.hasNext()) {
            CompatibilityHostingBounds b = (CompatibilityHostingBounds)i$.next();
            return Option.some((Object)Pair.pair((Object)b.min.build, (Object)b.max.build));
        }
        return Option.none();
    }

    public boolean isInServerBuildRange(int build) {
        Iterator i$ = this.hosting.server.iterator();
        if (i$.hasNext()) {
            CompatibilityHostingBounds b = (CompatibilityHostingBounds)i$.next();
            return build >= b.min.build && build <= b.max.build;
        }
        return false;
    }

    public Option<Integer> getServerMinBuild() {
        Iterator i$ = this.hosting.server.iterator();
        if (i$.hasNext()) {
            CompatibilityHostingBounds b = (CompatibilityHostingBounds)i$.next();
            return Option.some((Object)b.min.build);
        }
        return Option.none();
    }

    public Option<Integer> getServerMaxBuild() {
        Iterator i$ = this.hosting.server.iterator();
        if (i$.hasNext()) {
            CompatibilityHostingBounds b = (CompatibilityHostingBounds)i$.next();
            return Option.some((Object)b.max.build);
        }
        return Option.none();
    }

    public boolean isCompatibleWith(Predicate<ApplicationKey> applicationCriteria, HostingType hostingType, int build) {
        return applicationCriteria.apply((Object)this.getApplication()) && (hostingType == HostingType.CLOUD && this.hosting.isCloudCompatible() || hostingType != HostingType.CLOUD && this.hosting.isServerCompatible() && this.isInServerBuildRange(build));
    }

    public static Predicate<VersionCompatibility> compatibleWith(final Predicate<ApplicationKey> applicationCriteria, final HostingType hostingType, final int build) {
        return new Predicate<VersionCompatibility>(){

            public boolean apply(VersionCompatibility c) {
                return c.isCompatibleWith((Predicate<ApplicationKey>)applicationCriteria, hostingType, build);
            }
        };
    }

    static final class VersionPoint {
        int build;
        Option<String> version;

        VersionPoint(int build, Option<String> version) {
            this.build = build;
            this.version = version;
        }
    }

    static final class CompatibilityHostingBounds {
        VersionPoint min;
        VersionPoint max;

        CompatibilityHostingBounds(VersionPoint min, VersionPoint max) {
            this.min = min;
            this.max = max;
        }
    }

    static final class CompatibilityHosting {
        Option<CompatibilityHostingBounds> server;
        Option<Boolean> cloud;

        CompatibilityHosting(Option<CompatibilityHostingBounds> server, Option<Boolean> cloud) {
            this.server = server;
            this.cloud = cloud;
        }

        boolean isServerCompatible() {
            return this.server.isDefined();
        }

        boolean isCloudCompatible() {
            return (Boolean)this.cloud.getOrElse((Object)false);
        }
    }
}

