/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.impl;

import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.api.Page;
import com.atlassian.marketplace.client.api.PageReader;
import com.atlassian.marketplace.client.api.PageReference;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.atlassian.marketplace.client.model.Links;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Iterator;

final class PageImpl<T>
extends Page<T> {
    public static final String NEXT_REL = "next";
    public static final String PREVIOUS_REL = "prev";
    private final PageReference<T> reference;
    private final Option<URI> previousUri;
    private final Option<URI> nextUri;

    PageImpl(PageReference<T> reference, Links links, Iterable<T> items, int count, PageReader<T> reader) {
        super(items, count, reader);
        this.reference = (PageReference)Preconditions.checkNotNull(reference, (Object)"reference");
        Preconditions.checkNotNull((Object)links, (Object)"links");
        this.previousUri = links.getUri(PREVIOUS_REL);
        this.nextUri = links.getUri(NEXT_REL);
    }

    @Override
    public Option<PageReference<T>> getReference() {
        return Option.some(this.reference);
    }

    @Override
    public Option<PageReference<T>> getPrevious() {
        Iterator i$ = this.previousUri.iterator();
        if (i$.hasNext()) {
            URI p = (URI)i$.next();
            return Option.some(new PageReference(p, QueryBounds.offset(this.getBounds().getOffset() - (Integer)this.getBounds().getLimit().getOrElse((Object)this.size())).withLimit((Option<Integer>)this.getBounds().getLimit().orElse(Option.some((Object)this.size()))), this.reader));
        }
        return Option.none();
    }

    @Override
    public Option<PageReference<T>> getNext() {
        Iterator i$ = this.nextUri.iterator();
        if (i$.hasNext()) {
            URI n = (URI)i$.next();
            return Option.some(new PageReference(n, QueryBounds.offset(this.getBounds().getOffset() + (Integer)this.getBounds().getLimit().getOrElse((Object)this.size())).withLimit((Option<Integer>)this.getBounds().getLimit().orElse(Option.some((Object)this.size()))), this.reader));
        }
        return Option.none();
    }

    private QueryBounds getBounds() {
        return this.reference.getBounds();
    }
}

