/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.EnumWithKey;
import com.atlassian.marketplace.client.api.HostingType;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.util.Iterator;

public abstract class QueryProperties {
    private QueryProperties() {
    }

    static String describeParams(String className, Iterable<String> ... paramLists) {
        return className + "(" + Joiner.on((String)", ").join(Iterables.concat((Iterable[])paramLists)) + ")";
    }

    static Iterable<String> describeOptBoolean(String name, boolean value) {
        return value ? Option.some((Object)(name + "(true)")) : Option.none();
    }

    static <T extends EnumWithKey> Iterable<String> describeOptEnum(String name, Option<T> value) {
        Iterator i$ = value.iterator();
        if (i$.hasNext()) {
            EnumWithKey v = (EnumWithKey)i$.next();
            return Option.some((Object)(name + "(" + v.getKey() + ")"));
        }
        return Option.none();
    }

    static Iterable<String> describeValues(String name, Iterable<?> values) {
        if (!Iterables.isEmpty(values)) {
            return Option.some((Object)(name + "(" + Joiner.on((String)",").join(values) + ")"));
        }
        return Option.none();
    }

    public static interface WithVersion {
        public boolean isWithVersion();
    }

    public static interface Hosting {
        public Option<HostingType> getHosting();
    }

    public static interface Cost {
        public Option<com.atlassian.marketplace.client.api.Cost> getCost();
    }

    public static interface Bounds {
        public QueryBounds getBounds();
    }

    public static interface ApplicationCriteria {
        public Option<ApplicationKey> getApplication();

        public Option<Integer> getAppBuildNumber();
    }

    public static interface AccessToken {
        public Option<String> getAccessToken();
    }
}

