/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.HostingType;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public abstract class QueryBuilderProperties {
    private QueryBuilderProperties() {
    }

    static class ApplicationCriteriaHelper {
        public final Option<ApplicationKey> application;
        public final Option<Integer> appBuildNumber;

        public ApplicationCriteriaHelper() {
            this((Option<ApplicationKey>)Option.none(ApplicationKey.class), (Option<Integer>)Option.none(Integer.class));
        }

        private ApplicationCriteriaHelper(Option<ApplicationKey> application, Option<Integer> appBuildNumber) {
            this.application = application;
            this.appBuildNumber = appBuildNumber;
        }

        public ApplicationCriteriaHelper application(Option<ApplicationKey> application) {
            return new ApplicationCriteriaHelper((Option<ApplicationKey>)((Option)Preconditions.checkNotNull(application)), this.appBuildNumber);
        }

        public ApplicationCriteriaHelper appBuildNumber(Option<Integer> appBuildNumber) {
            return new ApplicationCriteriaHelper(this.application, (Option<Integer>)((Option)Preconditions.checkNotNull(appBuildNumber)));
        }

        public Iterable<String> describe() {
            ImmutableList.Builder ret = ImmutableList.builder();
            for (ApplicationKey a : this.application) {
                ret.add((Object)("application(" + a.getKey() + ")"));
            }
            for (Integer ab : this.appBuildNumber) {
                ret.add((Object)("appBuildNumber(" + ab + ")"));
            }
            return ret.build();
        }
    }

    public static interface WithVersion<T extends WithVersion<T>> {
        public T withVersion(boolean var1);
    }

    public static interface Hosting<T extends Hosting<T>> {
        public T hosting(Option<HostingType> var1);
    }

    public static interface Cost<T extends Cost<T>> {
        public T cost(Option<com.atlassian.marketplace.client.api.Cost> var1);
    }

    public static interface Bounds<T extends Bounds<T>> {
        public T bounds(QueryBounds var1);
    }

    public static interface ApplicationCriteria<T extends ApplicationCriteria<T>> {
        public T application(Option<ApplicationKey> var1);

        public T appBuildNumber(Option<Integer> var1);
    }

    public static interface AccessToken<T extends AccessToken<T>> {
        public T accessToken(Option<String> var1);
    }
}

