/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.fugue.Option;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;

public class QueryBounds {
    private static final QueryBounds DEFAULT = new QueryBounds(0, (Option<Integer>)Option.none(Integer.class));
    private static final QueryBounds EMPTY = new QueryBounds(0, (Option<Integer>)Option.some((Object)0));
    private final int offset;
    private final Option<Integer> limit;

    private QueryBounds(int offset, Option<Integer> limit) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset may not be negative");
        Iterator i$ = ((Option)Preconditions.checkNotNull(limit)).iterator();
        while (i$.hasNext()) {
            int l = (Integer)i$.next();
            Preconditions.checkArgument((l >= 0 ? 1 : 0) != 0, (Object)"limit may not be negative");
        }
        this.offset = offset;
        this.limit = limit;
    }

    public static QueryBounds offset(int offset) {
        return new QueryBounds(offset, (Option<Integer>)Option.none(Integer.class));
    }

    public static QueryBounds limit(Option<Integer> limit) {
        return new QueryBounds(0, limit);
    }

    public static QueryBounds defaultBounds() {
        return DEFAULT;
    }

    public static QueryBounds empty() {
        return EMPTY;
    }

    public int getOffset() {
        return this.offset;
    }

    public Option<Integer> getLimit() {
        return this.limit;
    }

    public QueryBounds withOffset(int offset) {
        return new QueryBounds(offset, this.limit);
    }

    public QueryBounds withLimit(Option<Integer> limit) {
        return new QueryBounds(this.offset, limit);
    }

    public boolean equals(Object other) {
        if (other instanceof QueryBounds) {
            QueryBounds o = (QueryBounds)other;
            return this.offset == o.offset && this.limit.equals(o.limit);
        }
        return false;
    }

    public int hashCode() {
        return this.offset + this.limit.hashCode();
    }

    public Iterable<String> describe() {
        ImmutableList.Builder ret = ImmutableList.builder();
        if (this.offset > 0) {
            ret.add((Object)("offset(" + this.offset + ")"));
        }
        for (Integer l : this.limit) {
            ret.add((Object)("limit(" + l + ")"));
        }
        return ret.build();
    }
}

