/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.Cost;
import com.atlassian.marketplace.client.api.HostingType;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.atlassian.marketplace.client.api.QueryBuilderProperties;
import com.atlassian.marketplace.client.api.QueryProperties;
import com.google.common.base.Preconditions;

public final class ProductQuery
implements QueryProperties.ApplicationCriteria,
QueryProperties.Bounds,
QueryProperties.Cost,
QueryProperties.Hosting,
QueryProperties.WithVersion {
    private static final ProductQuery DEFAULT_QUERY = ProductQuery.builder().build();
    private final QueryBuilderProperties.ApplicationCriteriaHelper app;
    private final Option<Cost> cost;
    private final Option<HostingType> hosting;
    private final boolean withVersion;
    private final QueryBounds bounds;

    public static Builder builder() {
        return new Builder();
    }

    public static ProductQuery any() {
        return DEFAULT_QUERY;
    }

    public static Builder builder(ProductQuery query) {
        Builder builder = ((Builder)((Builder)((Builder)((Builder)ProductQuery.builder().application((Option)query.getApplication())).appBuildNumber((Option)query.getAppBuildNumber())).cost((Option)query.getCost())).hosting((Option)query.getHosting())).withVersion(query.isWithVersion()).bounds(query.getBounds());
        return builder;
    }

    private ProductQuery(Builder builder) {
        this.app = builder.app;
        this.cost = builder.cost;
        this.hosting = builder.hosting;
        this.withVersion = builder.withVersion;
        this.bounds = builder.bounds;
    }

    @Override
    public Option<ApplicationKey> getApplication() {
        return this.app.application;
    }

    @Override
    public Option<Integer> getAppBuildNumber() {
        return this.app.appBuildNumber;
    }

    @Override
    public Option<Cost> getCost() {
        return this.cost;
    }

    @Override
    public Option<HostingType> getHosting() {
        return this.hosting;
    }

    @Override
    public boolean isWithVersion() {
        return this.withVersion;
    }

    @Override
    public QueryBounds getBounds() {
        return this.bounds;
    }

    public String toString() {
        return QueryProperties.describeParams("ProductQuery", this.app.describe(), QueryProperties.describeOptEnum("cost", this.cost), QueryProperties.describeOptEnum("hosting", this.hosting), QueryProperties.describeOptBoolean("withVersion", this.withVersion), this.bounds.describe());
    }

    public boolean equals(Object other) {
        return other instanceof ProductQuery ? this.toString().equals(other.toString()) : false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static class Builder
    implements QueryBuilderProperties.ApplicationCriteria<Builder>,
    QueryBuilderProperties.Bounds<Builder>,
    QueryBuilderProperties.Cost<Builder>,
    QueryBuilderProperties.Hosting<Builder>,
    QueryBuilderProperties.WithVersion<Builder> {
        private QueryBuilderProperties.ApplicationCriteriaHelper app = new QueryBuilderProperties.ApplicationCriteriaHelper();
        private Option<Cost> cost = Option.none();
        private Option<HostingType> hosting = Option.none();
        private boolean withVersion = false;
        private QueryBounds bounds = QueryBounds.defaultBounds();

        public ProductQuery build() {
            return new ProductQuery(this);
        }

        @Override
        public Builder application(Option<ApplicationKey> application) {
            this.app = this.app.application(application);
            return this;
        }

        @Override
        public Builder appBuildNumber(Option<Integer> appBuildNumber) {
            this.app = this.app.appBuildNumber(appBuildNumber);
            return this;
        }

        @Override
        public Builder cost(Option<Cost> cost) {
            this.cost = (Option)Preconditions.checkNotNull(cost);
            return this;
        }

        @Override
        public Builder hosting(Option<HostingType> hosting) {
            this.hosting = (Option)Preconditions.checkNotNull(hosting);
            return this;
        }

        @Override
        public Builder withVersion(boolean withVersion) {
            this.withVersion = withVersion;
            return this;
        }

        @Override
        public Builder bounds(QueryBounds bounds) {
            this.bounds = (QueryBounds)Preconditions.checkNotNull((Object)bounds);
            return this;
        }
    }
}

