/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.api.ApplicationKey;
import com.atlassian.marketplace.client.api.Cost;
import com.atlassian.marketplace.client.api.EnumWithKey;
import com.atlassian.marketplace.client.api.HostingType;
import com.atlassian.marketplace.client.api.QueryBounds;
import com.atlassian.marketplace.client.api.QueryBuilderProperties;
import com.atlassian.marketplace.client.api.QueryProperties;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;

public final class AddonQuery
implements QueryProperties.AccessToken,
QueryProperties.ApplicationCriteria,
QueryProperties.Bounds,
QueryProperties.Cost,
QueryProperties.Hosting,
QueryProperties.WithVersion {
    private static final AddonQuery DEFAULT_QUERY = AddonQuery.builder().build();
    private final Option<String> accessToken;
    private final QueryBuilderProperties.ApplicationCriteriaHelper app;
    private final QueryBounds bounds;
    private final Iterable<String> categoryNames;
    private final Option<Cost> cost;
    private final boolean forThisUserOnly;
    private final Option<HostingType> hosting;
    private final Option<IncludeHiddenType> includeHidden;
    private final boolean includePrivate;
    private final Option<String> label;
    private final Option<TreatPartlyFreeAs> treatPartlyFreeAs;
    private final Option<String> searchText;
    private final Option<View> view;
    private final boolean withVersion;

    public static Builder builder() {
        return new Builder();
    }

    public static AddonQuery any() {
        return DEFAULT_QUERY;
    }

    public static Builder builder(AddonQuery query) {
        Builder builder = ((Builder)((Builder)((Builder)((Builder)AddonQuery.builder().application((Option)query.getApplication())).appBuildNumber((Option)query.getAppBuildNumber())).categoryNames(query.getCategoryNames()).cost((Option)query.getCost())).forThisUserOnly(query.isForThisUserOnly()).hosting((Option)query.getHosting())).includeHidden(query.getIncludeHidden()).includePrivate(query.isIncludePrivate()).label(query.getLabel()).treatPartlyFreeAs(query.getTreatPartlyFreeAs()).view(query.getView()).withVersion(query.isWithVersion()).bounds(query.getBounds()).searchText(query.getSearchText());
        return builder;
    }

    private AddonQuery(Builder builder) {
        this.accessToken = builder.accessToken;
        this.app = builder.app;
        this.bounds = builder.bounds;
        this.categoryNames = builder.categoryNames;
        this.cost = builder.cost;
        this.forThisUserOnly = builder.forThisUserOnly;
        this.hosting = builder.hosting;
        this.includeHidden = builder.includeHidden;
        this.includePrivate = builder.includePrivate;
        this.label = builder.label;
        this.searchText = builder.searchText;
        this.treatPartlyFreeAs = builder.treatPartlyFreeAs;
        this.view = builder.view;
        this.withVersion = builder.withVersion;
    }

    @Override
    public Option<String> getAccessToken() {
        return this.accessToken;
    }

    @Override
    public Option<ApplicationKey> getApplication() {
        return this.app.application;
    }

    @Override
    public Option<Integer> getAppBuildNumber() {
        return this.app.appBuildNumber;
    }

    public Iterable<String> getCategoryNames() {
        return this.categoryNames;
    }

    @Override
    public Option<Cost> getCost() {
        return this.cost;
    }

    public boolean isForThisUserOnly() {
        return this.forThisUserOnly;
    }

    public Option<IncludeHiddenType> getIncludeHidden() {
        return this.includeHidden;
    }

    public boolean isIncludePrivate() {
        return this.includePrivate;
    }

    @Override
    public Option<HostingType> getHosting() {
        return this.hosting;
    }

    public Option<String> getLabel() {
        return this.label;
    }

    public Option<TreatPartlyFreeAs> getTreatPartlyFreeAs() {
        return this.treatPartlyFreeAs;
    }

    public Option<String> getSearchText() {
        return this.searchText;
    }

    public Option<View> getView() {
        return this.view;
    }

    @Override
    public boolean isWithVersion() {
        return this.withVersion;
    }

    @Override
    public QueryBounds getBounds() {
        return this.bounds;
    }

    public String toString() {
        return QueryProperties.describeParams("AddonQuery", QueryProperties.describeValues("accessToken", this.accessToken), this.app.describe(), QueryProperties.describeValues("categoryNames", this.categoryNames), QueryProperties.describeOptEnum("cost", this.cost), QueryProperties.describeOptBoolean("forThisUserOnly", this.forThisUserOnly), QueryProperties.describeOptEnum("hosting", this.hosting), QueryProperties.describeOptEnum("includeHidden", this.includeHidden), QueryProperties.describeOptBoolean("includePrivate", this.includePrivate), QueryProperties.describeValues("label", this.label), QueryProperties.describeValues("searchText", this.searchText), QueryProperties.describeOptEnum("treatPartlyFreeAs", this.treatPartlyFreeAs), QueryProperties.describeOptEnum("view", this.view), QueryProperties.describeOptBoolean("withVersion", this.withVersion), this.bounds.describe());
    }

    public boolean equals(Object other) {
        return other instanceof AddonQuery ? this.toString().equals(other.toString()) : false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum View implements EnumWithKey
    {
        BY_ATLASSIAN("atlassian"),
        FEATURED("featured"),
        HIGHEST_RATED("highest-rated"),
        POPULAR("popular"),
        RECENTLY_UPDATED("recent"),
        TOP_GROSSING("top-grossing"),
        TRENDING("trending");

        private final String key;

        private View(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    public static enum TreatPartlyFreeAs implements EnumWithKey
    {
        FREE("free"),
        PAID("paid");

        private final String key;

        private TreatPartlyFreeAs(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    public static enum IncludeHiddenType implements EnumWithKey
    {
        VISIBLE_IN_APP("visibleInApp"),
        ALL("all");

        private final String key;

        private IncludeHiddenType(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }
    }

    public static class Builder
    implements QueryBuilderProperties.AccessToken<Builder>,
    QueryBuilderProperties.ApplicationCriteria<Builder>,
    QueryBuilderProperties.Bounds<Builder>,
    QueryBuilderProperties.Cost<Builder>,
    QueryBuilderProperties.Hosting<Builder>,
    QueryBuilderProperties.WithVersion<Builder> {
        private Option<String> accessToken = Option.none();
        private QueryBuilderProperties.ApplicationCriteriaHelper app = new QueryBuilderProperties.ApplicationCriteriaHelper();
        private QueryBounds bounds = QueryBounds.defaultBounds();
        private Iterable<String> categoryNames = ImmutableList.of();
        private Option<Cost> cost = Option.none();
        private boolean forThisUserOnly = false;
        private Option<HostingType> hosting = Option.none();
        private Option<IncludeHiddenType> includeHidden = Option.none();
        private boolean includePrivate = false;
        private Option<String> label = Option.none();
        private Option<TreatPartlyFreeAs> treatPartlyFreeAs = Option.none();
        private Option<String> searchText = Option.none();
        private Option<View> view = Option.none();
        private boolean withVersion = false;

        public AddonQuery build() {
            return new AddonQuery(this);
        }

        @Override
        public Builder accessToken(Option<String> accessToken) {
            this.accessToken = (Option)Preconditions.checkNotNull(accessToken);
            return this;
        }

        @Override
        public Builder application(Option<ApplicationKey> application) {
            this.app = this.app.application(application);
            return this;
        }

        @Override
        public Builder appBuildNumber(Option<Integer> appBuildNumber) {
            this.app = this.app.appBuildNumber(appBuildNumber);
            return this;
        }

        public Builder categoryNames(Iterable<String> categoryNames) {
            this.categoryNames = ImmutableList.copyOf(categoryNames);
            return this;
        }

        @Override
        public Builder cost(Option<Cost> cost) {
            this.cost = (Option)Preconditions.checkNotNull(cost);
            return this;
        }

        public Builder forThisUserOnly(boolean forThisUserOnly) {
            this.forThisUserOnly = forThisUserOnly;
            return this;
        }

        @Override
        public Builder hosting(Option<HostingType> hosting) {
            this.hosting = (Option)Preconditions.checkNotNull(hosting);
            return this;
        }

        public Builder includeHidden(Option<IncludeHiddenType> includeHidden) {
            this.includeHidden = (Option)Preconditions.checkNotNull(includeHidden);
            return this;
        }

        public Builder includePrivate(boolean includePrivate) {
            this.includePrivate = includePrivate;
            return this;
        }

        public Builder label(Option<String> label) {
            this.label = (Option)Preconditions.checkNotNull(label);
            return this;
        }

        public Builder treatPartlyFreeAs(Option<TreatPartlyFreeAs> treatPartlyFreeAs) {
            this.treatPartlyFreeAs = treatPartlyFreeAs;
            return this;
        }

        public Builder searchText(Option<String> searchText) {
            this.searchText = (Option)Preconditions.checkNotNull(searchText);
            return this;
        }

        public Builder view(Option<View> view) {
            this.view = (Option)Preconditions.checkNotNull(view);
            return this;
        }

        @Override
        public Builder withVersion(boolean withVersion) {
            this.withVersion = withVersion;
            return this;
        }

        @Override
        public Builder bounds(QueryBounds bounds) {
            this.bounds = (QueryBounds)Preconditions.checkNotNull((Object)bounds);
            return this;
        }
    }
}

