/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.websudo;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.oauth.util.RequestAnnotations;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import java.io.IOException;
import java.net.URLEncoder;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class JIRASalWebSudoManager
implements WebSudoManager {
    private final InternalWebSudoManager internalWebSudoManager;
    private final ApplicationProperties applicationProperties;

    public JIRASalWebSudoManager(ApplicationProperties settingsManager, InternalWebSudoManager internalWebSudoManager) {
        this.internalWebSudoManager = (InternalWebSudoManager)Assertions.notNull((String)"internalWebSudoManager", (Object)internalWebSudoManager);
        this.applicationProperties = (ApplicationProperties)Assertions.notNull((String)"applicationProperties", (Object)settingsManager);
    }

    public boolean canExecuteRequest(HttpServletRequest httpServletRequest) {
        HttpSession session = httpServletRequest.getSession(false);
        return !this.internalWebSudoManager.isEnabled() || RequestAnnotations.isOAuthRequest((HttpServletRequest)httpServletRequest) || this.internalWebSudoManager.hasValidSession(session);
    }

    public void enforceWebSudoProtection(HttpServletRequest request, HttpServletResponse response) {
        String encoding = this.applicationProperties.getEncoding();
        try {
            String queryString = request.getQueryString();
            String pathInfo = request.getPathInfo();
            String destination = request.getServletPath() + (null != pathInfo ? pathInfo : "") + (null != queryString ? "?" + queryString : "");
            response.sendRedirect(request.getContextPath() + "/secure/admin/WebSudoAuthenticate!default.jspa?webSudoDestination=" + URLEncoder.encode(destination, encoding));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to redirect to /authenticate.action");
        }
    }

    public void willExecuteWebSudoRequest(HttpServletRequest httpServletRequest) throws WebSudoSessionException {
        if (!this.canExecuteRequest(httpServletRequest)) {
            throw new WebSudoSessionException("Invalid request: Not in a WebSudo session");
        }
        this.internalWebSudoManager.markWebSudoRequest(httpServletRequest);
    }
}

