/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.usersettings;

import com.atlassian.fugue.Option;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsBuilder;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.sal.core.usersettings.DefaultUserSettings;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.opensymphony.module.propertyset.PropertySet;
import java.util.Collection;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraUserSettingsService
implements UserSettingsService {
    private static final Logger log = LoggerFactory.getLogger(JiraUserSettingsService.class);
    private final UserPropertyManager userPropertyManager;
    private final UserManager userManager;

    public JiraUserSettingsService(UserPropertyManager userPropertyManager, UserManager userManager) {
        this.userPropertyManager = userPropertyManager;
        this.userManager = userManager;
    }

    public UserSettings getUserSettings(String username) {
        UserSettingsBuilder userSettingsBuilder = this.getUserSettingsBuilder(this.getUser(username));
        return userSettingsBuilder.build();
    }

    public UserSettings getUserSettings(UserKey userKey) {
        Assertions.is((String)"userKey cannot be null", (userKey != null ? 1 : 0) != 0);
        UserSettingsBuilder userSettingsBuilder = this.getUserSettingsBuilder(this.getUser(userKey));
        return userSettingsBuilder.build();
    }

    public void updateUserSettings(String username, Function<UserSettingsBuilder, UserSettings> updateFunction) {
        UserSettingsBuilder userSettingsBuilder = this.getUserSettingsBuilder(this.getUser(username));
        updateFunction.apply((Object)userSettingsBuilder);
    }

    public void updateUserSettings(UserKey userKey, Function<UserSettingsBuilder, UserSettings> updateFunction) {
        Assertions.is((String)"userKey cannot be null", (userKey != null ? 1 : 0) != 0);
        UserSettingsBuilder userSettingsBuilder = this.getUserSettingsBuilder(this.getUser(userKey));
        updateFunction.apply((Object)userSettingsBuilder);
    }

    private static UserSettings buildUserSettings(PropertySet propertySet) {
        Collection propertySetKeys = propertySet.getKeys("sal_");
        UserSettingsBuilder settings = DefaultUserSettings.builder();
        ImmutableList settingKeys = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)propertySetKeys, (Function)PrefixStrippingFunction.INSTANCE));
        block5: for (String settingKey : settingKeys) {
            int type = propertySet.getType("sal_" + settingKey);
            switch (type) {
                case 1: {
                    settings.put(settingKey, propertySet.getBoolean("sal_" + settingKey));
                    continue block5;
                }
                case 5: {
                    settings.put(settingKey, propertySet.getString("sal_" + settingKey));
                    continue block5;
                }
                case 3: {
                    settings.put(settingKey, propertySet.getLong("sal_" + settingKey));
                    continue block5;
                }
            }
            log.info("Property type '{}' is not supported by the SAL UserSettingsService", (Object)type);
        }
        return settings.build();
    }

    private UserSettingsBuilder getUserSettingsBuilder(ApplicationUser user) {
        PropertySet propertySet = this.userPropertyManager.getPropertySet(user);
        return new JiraPropertySetUserSettingsBuilder(propertySet);
    }

    private ApplicationUser getUser(String userName) {
        ApplicationUser user = this.userManager.getUserByName(userName);
        Assertions.is((String)String.format("No user exists with the username %s", userName), (user != null ? 1 : 0) != 0);
        return user;
    }

    private ApplicationUser getUser(UserKey userKey) {
        ApplicationUser user = this.userManager.getUserByKey(userKey.getStringValue());
        Assertions.is((String)String.format("No user exists with the key %s", userKey.getStringValue()), (user != null ? 1 : 0) != 0);
        return user;
    }

    static class JiraPropertySetUserSettingsBuilder
    implements UserSettingsBuilder {
        private final PropertySet propertySet;

        public JiraPropertySetUserSettingsBuilder(PropertySet propertySet) {
            this.propertySet = propertySet;
        }

        public UserSettingsBuilder put(String key, String value) {
            JiraPropertySetUserSettingsBuilder.checkArgumentKey(key);
            JiraPropertySetUserSettingsBuilder.checkArgumentValue(value);
            this.propertySet.setString("sal_" + key, value);
            return this;
        }

        public UserSettingsBuilder put(String key, boolean value) {
            JiraPropertySetUserSettingsBuilder.checkArgumentKey(key);
            this.propertySet.setBoolean("sal_" + key, value);
            return this;
        }

        public UserSettingsBuilder put(String key, long value) {
            JiraPropertySetUserSettingsBuilder.checkArgumentKey(key);
            this.propertySet.setLong("sal_" + key, value);
            return this;
        }

        public UserSettingsBuilder remove(String key) {
            JiraPropertySetUserSettingsBuilder.checkArgumentKey(key);
            this.propertySet.remove("sal_" + key);
            return this;
        }

        public Option<Object> get(String key) {
            JiraPropertySetUserSettingsBuilder.checkArgumentKey(key);
            int type = this.propertySet.getType("sal_" + key);
            switch (type) {
                case 3: {
                    return Option.some((Object)this.propertySet.getLong("sal_" + key));
                }
                case 1: {
                    return Option.some((Object)this.propertySet.getBoolean("sal_" + key));
                }
                case 5: {
                    return Option.some((Object)this.propertySet.getString("sal_" + key));
                }
            }
            return Option.none();
        }

        public Set<String> getKeys() {
            Iterable transform = Iterables.transform((Iterable)this.propertySet.getKeys("sal_"), (Function)PrefixStrippingFunction.INSTANCE);
            return ImmutableSet.copyOf((Iterable)transform);
        }

        public UserSettings build() {
            return JiraUserSettingsService.buildUserSettings(this.propertySet);
        }

        private static void checkArgumentKey(String key) {
            Assertions.is((String)"key cannot be null", (key != null ? 1 : 0) != 0);
            Assertions.is((String)String.format("key cannot be longer than %s characters", UserSettingsService.MAX_KEY_LENGTH), (key.length() <= UserSettingsService.MAX_KEY_LENGTH ? 1 : 0) != 0);
        }

        private static void checkArgumentValue(String value) {
            Assertions.is((String)"value cannot be null", (value != null ? 1 : 0) != 0);
            Assertions.is((String)String.format("value cannot be longer than %s characters", 255), (value.length() <= 255 ? 1 : 0) != 0);
        }
    }

    private static enum PrefixStrippingFunction implements Function<Object, String>
    {
        INSTANCE;


        public String apply(Object input) {
            String val = input.toString();
            return val.substring("sal_".length());
        }
    }
}

