/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestrictionImpl;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserResolutionException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import javax.annotation.Nullable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import webwork.util.URLCodec;

public class DefaultUserManager
implements com.atlassian.sal.api.user.UserManager {
    private final GlobalPermissionManager globalPermissionManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final CrowdService crowdService;
    private final AvatarService avatarService;
    private final UserManager userManager;

    public DefaultUserManager(GlobalPermissionManager globalPermissionManager, JiraAuthenticationContext jiraAuthenticationContext, CrowdService crowdService, AvatarService avatarService, UserManager userManager) {
        this.globalPermissionManager = globalPermissionManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.crowdService = crowdService;
        this.avatarService = avatarService;
        this.userManager = userManager;
    }

    public String getRemoteUsername() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (user == null) {
            return null;
        }
        return user.getUsername();
    }

    public UserProfile getRemoteUser() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (user == null) {
            return null;
        }
        return new JiraUserProfile(user);
    }

    @Nullable
    public UserKey getRemoteUserKey() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        if (user == null) {
            return null;
        }
        return new UserKey(user.getKey());
    }

    public String getRemoteUsername(HttpServletRequest request) {
        return this.getRemoteUsername();
    }

    public UserProfile getRemoteUser(HttpServletRequest httpServletRequest) {
        return this.getRemoteUser();
    }

    @Nullable
    public UserKey getRemoteUserKey(HttpServletRequest request) {
        return this.getRemoteUserKey();
    }

    public boolean isSystemAdmin(String username) {
        if (StringUtils.isNotEmpty((String)username)) {
            ApplicationUser user = this.userManager.getUserByName(username);
            return user != null && this.globalPermissionManager.hasPermission(44, user);
        }
        return false;
    }

    public boolean isSystemAdmin(UserKey userKey) {
        if (userKey != null) {
            ApplicationUser user = this.userManager.getUserByKey(userKey.getStringValue());
            return user != null && this.globalPermissionManager.hasPermission(44, user);
        }
        return false;
    }

    public boolean isAdmin(String username) {
        if (StringUtils.isNotEmpty((String)username)) {
            ApplicationUser user = this.userManager.getUserByName(username);
            return user != null && this.globalPermissionManager.hasPermission(0, user);
        }
        return false;
    }

    public boolean isAdmin(UserKey userKey) {
        if (userKey != null) {
            ApplicationUser user = this.userManager.getUserByKey(userKey.getStringValue());
            return user != null && this.globalPermissionManager.hasPermission(0, user);
        }
        return false;
    }

    public boolean authenticate(String username, String password) {
        try {
            return this.crowdService.authenticate(username, password) != null;
        }
        catch (FailedAuthenticationException e) {
            return false;
        }
    }

    public Principal resolve(String username) throws UserResolutionException {
        return this.crowdService.getUser(username);
    }

    public Iterable<String> findGroupNamesByPrefix(String prefix, int startIndex, int maxResults) {
        return this.crowdService.search(this.getGroupQuery(prefix, startIndex, maxResults));
    }

    private GroupQuery<String> getGroupQuery(String prefix, int startIndex, int maxResults) {
        return new GroupQuery(String.class, GroupType.GROUP, (SearchRestriction)(StringUtils.isBlank((String)prefix) ? NullRestrictionImpl.INSTANCE : Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)prefix)), startIndex, maxResults);
    }

    public boolean isUserInGroup(String username, String groupName) {
        User user = this.crowdService.getUser(username);
        Group group = this.crowdService.getGroup(groupName);
        return user != null && group != null && this.crowdService.isUserMemberOfGroup(user, group);
    }

    public boolean isUserInGroup(UserKey userKey, String groupName) {
        ApplicationUser user = this.userManager.getUserByKey(userKey.getStringValue());
        Group group = this.crowdService.getGroup(groupName);
        return user != null && group != null && this.crowdService.isUserMemberOfGroup(user.getDirectoryUser(), group);
    }

    public UserProfile getUserProfile(String username) {
        ApplicationUser user = this.userManager.getUserByName(username);
        if (user != null) {
            return new JiraUserProfile(user);
        }
        return null;
    }

    public UserProfile getUserProfile(UserKey userKey) {
        ApplicationUser user;
        if (userKey != null && (user = this.userManager.getUserByKey(userKey.getStringValue())) != null) {
            return new JiraUserProfile(user);
        }
        return null;
    }

    class JiraUserProfile
    implements UserProfile {
        private final ApplicationUser user;

        JiraUserProfile(ApplicationUser user) {
            this.user = user;
        }

        public UserKey getUserKey() {
            return new UserKey(this.user.getKey());
        }

        public String getUsername() {
            return this.user.getUsername();
        }

        public String getFullName() {
            return this.user.getDisplayName();
        }

        public String getEmail() {
            return this.user.getEmailAddress();
        }

        public URI getProfilePictureUri(int width, int height) {
            Avatar.Size theSize = Avatar.Size.biggerThan((int)Math.max(width, height));
            if (null == theSize) {
                return null;
            }
            return this.getProfilePictureUri(theSize);
        }

        public URI getProfilePictureUri() {
            return this.getProfilePictureUri(Avatar.Size.LARGE);
        }

        private URI getProfilePictureUri(Avatar.Size size) {
            ApplicationUser remoteUser = DefaultUserManager.this.jiraAuthenticationContext.getUser();
            return DefaultUserManager.this.avatarService.getAvatarURL(remoteUser, this.user, size);
        }

        public URI getProfilePageUri() {
            String username = this.getUsername();
            if (username == null) {
                return null;
            }
            try {
                return new URI(String.format("/secure/ViewProfile.jspa?name=%s", URLCodec.encode((String)username, (String)"UTF-8")));
            }
            catch (URISyntaxException e) {
                return null;
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
    }
}

