/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.upgrade;

import com.atlassian.jira.ofbiz.FieldMap;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.DelegatorInterface;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeTo_v2
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(PluginUpgradeTask.class);
    private static final String OLD_CLASS_NAME = "com.atlassian.sal.jira.scheduling.JiraPluginScheduler$JiraPluginSchedulerService";
    private static final String NEW_CLASS_NAME = "com.atlassian.sal.jira.scheduling.JiraPluginSchedulerService";

    public int getBuildNumber() {
        return 2;
    }

    public String getShortDescription() {
        return "Fixing the classname for services using JiraPluginSchedulerService class";
    }

    public Collection<Message> doUpgrade() throws Exception {
        DelegatorInterface genericDelegator = (DelegatorInterface)ComponentLocator.getComponent(DelegatorInterface.class);
        List services = genericDelegator.findByAnd("ServiceConfig", (Map)FieldMap.build((String)"clazz", (Object)OLD_CLASS_NAME));
        if (services.isEmpty()) {
            log.info("No JiraPluginSchedulerService found. No classname fixing required");
        }
        for (GenericValue service : services) {
            service.set("clazz", (Object)NEW_CLASS_NAME);
            log.info("Fixing classname for service " + service.getString("name"));
        }
        genericDelegator.storeAll(services);
        return null;
    }

    public String getPluginKey() {
        return "com.atlassian.sal.jira";
    }
}

