/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.upgrade;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.sal.core.upgrade.DefaultPluginUpgradeManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JiraPluginUpgradeManager
extends DefaultPluginUpgradeManager {
    static final String SAL_PLUGIN_KEY = "com.atlassian.sal.jira";
    private static final String SAL_UPGRADE_LOCK_NAME = "com.atlassian.sal.jira.upgrade";
    private final ClusterLockService clusterLockService = (ClusterLockService)ComponentAccessor.getComponent(ClusterLockService.class);

    public JiraPluginUpgradeManager(List<PluginUpgradeTask> upgradeTasks, TransactionTemplate transactionTemplate, PluginAccessor pluginAccessor, PluginSettingsFactory pluginSettingsFactory) {
        super(upgradeTasks, transactionTemplate, pluginAccessor, pluginSettingsFactory, ComponentAccessor.getPluginEventManager(), (ClusterLockService)ComponentAccessor.getComponent(ClusterLockService.class));
    }

    protected Map<String, List<PluginUpgradeTask>> getUpgradeTasks() {
        Map upgradeTasks = super.getUpgradeTasks();
        List salTasks = (List)upgradeTasks.get(SAL_PLUGIN_KEY);
        if (salTasks == null) {
            return upgradeTasks;
        }
        LinkedHashMap<String, List<PluginUpgradeTask>> sortedUpgradeTasks = new LinkedHashMap<String, List<PluginUpgradeTask>>();
        sortedUpgradeTasks.put(SAL_PLUGIN_KEY, salTasks);
        sortedUpgradeTasks.putAll(upgradeTasks);
        return sortedUpgradeTasks;
    }

    public List<Message> upgradeInternal() {
        ClusterLock lock = this.clusterLockService.getLockForName(SAL_UPGRADE_LOCK_NAME);
        lock.lock();
        try {
            List list = super.upgradeInternal();
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> upgradeInternal(Plugin plugin) {
        ClusterLock lock = this.clusterLockService.getLockForName(SAL_UPGRADE_LOCK_NAME);
        lock.lock();
        try {
            List list = super.upgradeInternal(plugin);
            return list;
        }
        finally {
            lock.unlock();
        }
    }
}

