/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.timezone;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.timezone.TimeZoneService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.sal.api.user.UserKey;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class JiraTimeZoneManager
implements TimeZoneManager {
    private final TimeZoneService timeZoneService;
    private final com.atlassian.jira.timezone.TimeZoneManager timeZoneManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final UserManager userManager;

    public JiraTimeZoneManager(TimeZoneService timeZoneService, com.atlassian.jira.timezone.TimeZoneManager timeZoneManager, JiraAuthenticationContext jiraAuthenticationContext, UserManager userManager) {
        this.timeZoneService = timeZoneService;
        this.timeZoneManager = timeZoneManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.userManager = userManager;
    }

    @Nonnull
    public TimeZone getUserTimeZone() {
        return this.timeZoneManager.getLoggedInUserTimeZone();
    }

    @Nonnull
    public TimeZone getUserTimeZone(@Nonnull UserKey user) {
        ApplicationUser applicationUser = this.userManager.getUserByKey(user.getStringValue());
        if (applicationUser == null) {
            return this.getDefaultTimeZone();
        }
        return this.timeZoneManager.getTimeZoneforUser(applicationUser);
    }

    @Nonnull
    public TimeZone getDefaultTimeZone() {
        return this.timeZoneService.getDefaultTimeZoneInfo((JiraServiceContext)new JiraServiceContextImpl(this.jiraAuthenticationContext.getLoggedInUser())).toTimeZone();
    }
}

