/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.search;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.DefaultIndexManager;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchContextFactory;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.search.ResourceType;
import com.atlassian.sal.api.search.SearchMatch;
import com.atlassian.sal.api.search.SearchProvider;
import com.atlassian.sal.api.search.SearchResults;
import com.atlassian.sal.api.search.query.SearchQuery;
import com.atlassian.sal.api.search.query.SearchQueryParser;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.core.message.DefaultMessage;
import com.atlassian.sal.core.search.BasicResourceType;
import com.atlassian.sal.core.search.BasicSearchMatch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraSearchProvider
implements SearchProvider {
    private static final Logger log = LoggerFactory.getLogger(JiraSearchProvider.class);
    private final com.atlassian.jira.issue.search.SearchProvider searchProvider;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;
    private final SearchQueryParser searchQueryParser;
    private final ApplicationProperties applicationProperties;
    private final SearchContextFactory searchContextFactory;
    private final UserManager userManager;

    public JiraSearchProvider(com.atlassian.jira.issue.search.SearchProvider searchProvider, IssueManager issueManager, JiraAuthenticationContext authenticationContext, SearchQueryParser searchQueryParser, ApplicationProperties applicationProperties, SearchContextFactory searchContextFactory, UserManager userManager) {
        this.searchProvider = searchProvider;
        this.issueManager = issueManager;
        this.authenticationContext = authenticationContext;
        this.searchQueryParser = searchQueryParser;
        this.applicationProperties = applicationProperties;
        this.searchContextFactory = searchContextFactory;
        this.userManager = userManager;
    }

    public SearchResults search(String username, String searchString) {
        return this.internalSearch(this.getUser(username), username, searchString);
    }

    public SearchResults search(UserKey userKey, String searchString) {
        return this.internalSearch(this.getUser(userKey), userKey == null ? null : userKey.getStringValue(), searchString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResults internalSearch(ApplicationUser remoteUser, String remoteUsername, String searchString) {
        SearchQuery searchQuery = this.searchQueryParser.parse(searchString);
        int maxHits = searchQuery.getParameter("maxhits", Integer.MAX_VALUE);
        ApplicationUser oldAuthenticationContextUser = this.getAuthenticationContextUser();
        try {
            this.setAuthenticationContextUser(remoteUser);
            if (remoteUser == null) {
                log.info("User '" + remoteUsername + "' not found. Running anonymous search...");
            }
            Collection<Issue> issues = this.getIssuesFromQuery(searchQuery.getSearchString());
            Query query = this.createQuery(searchQuery);
            SearchResults searchResults = this.performSearch(maxHits, query, issues, remoteUser);
            return searchResults;
        }
        finally {
            this.setAuthenticationContextUser(oldAuthenticationContextUser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchResults performSearch(int maxHits, Query query, Collection<Issue> issues, ApplicationUser remoteUser) {
        try {
            long startTime = System.currentTimeMillis();
            PagerFilter pagerFilter = new PagerFilter();
            pagerFilter.setMax(maxHits);
            com.atlassian.jira.issue.search.SearchResults searchResults = this.searchProvider.search(query, remoteUser, pagerFilter);
            issues.addAll(searchResults.getIssues());
            int numResults = searchResults.getTotal() - searchResults.getIssues().size() + issues.size();
            List<Object> trimmedResults = new ArrayList<Issue>(issues);
            if (trimmedResults.size() > maxHits) {
                trimmedResults = trimmedResults.subList(0, maxHits);
            }
            SearchResults searchResults2 = new SearchResults(this.transformResults(trimmedResults), numResults, System.currentTimeMillis() - startTime);
            return searchResults2;
        }
        catch (SearchException e) {
            log.error("Error executing search", (Throwable)e);
            ArrayList<DefaultMessage> errors = new ArrayList<DefaultMessage>();
            errors.add(new DefaultMessage(e.getMessage(), new Serializable[0]));
            SearchResults searchResults = new SearchResults(errors);
            return searchResults;
        }
        finally {
            DefaultIndexManager.flushThreadLocalSearchers();
        }
    }

    private List<SearchMatch> transformResults(Collection<Issue> issues) {
        ArrayList<SearchMatch> matches = new ArrayList<SearchMatch>(issues.size());
        for (Issue issue : issues) {
            matches.add((SearchMatch)new BasicSearchMatch(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + "/browse/" + issue.getKey(), "[" + issue.getKey() + "] " + issue.getSummary(), issue.getDescription(), (ResourceType)new BasicResourceType(this.applicationProperties, issue.getIssueTypeId())));
        }
        return matches;
    }

    private Query createQuery(SearchQuery query) {
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder();
        JqlClauseBuilder clause = builder.where();
        String projectKey = query.getParameter("project");
        if (projectKey != null) {
            clause.project(new String[]{projectKey}).and();
        }
        String[] rawTerms = query.getSearchString().trim().split("\\s");
        ArrayList<String> terms = new ArrayList<String>(rawTerms.length);
        for (String term : rawTerms) {
            if (term.length() <= 0) continue;
            terms.add(term);
        }
        for (int i = 0; i < terms.size(); ++i) {
            if (i > 0) {
                clause.and();
            }
            String term = (String)terms.get(i);
            clause.sub().summary(term).or().description(term).or().comment(term).endsub();
        }
        return builder.buildQuery();
    }

    Collection<String> getIssueKeysFromQuery(String query) {
        return JiraKeyUtils.getIssueKeysFromString((String)query);
    }

    private Collection<Issue> getIssuesFromQuery(String query) {
        Collection<String> issueKeys = this.getIssueKeysFromQuery(query);
        LinkedHashSet<Issue> issues = new LinkedHashSet<Issue>();
        for (String issueKey : issueKeys) {
            Issue issue = this.getIssueByKey(issueKey);
            if (issue == null) continue;
            issues.add(issue);
        }
        return issues;
    }

    private Issue getIssueByKey(String issueKey) {
        try {
            return this.issueManager.getIssueObject(issueKey);
        }
        catch (DataAccessException dae) {
            return null;
        }
    }

    SearchContext getSearchContext() {
        return this.searchContextFactory.create();
    }

    private ApplicationUser getUser(String username) {
        return this.userManager.getUserByName(username);
    }

    private ApplicationUser getUser(UserKey userKey) {
        if (userKey != null) {
            return this.userManager.getUserByKey(userKey.getStringValue());
        }
        return null;
    }

    private void setAuthenticationContextUser(ApplicationUser remoteUser) {
        this.authenticationContext.setLoggedInUser(remoteUser);
    }

    private ApplicationUser getAuthenticationContextUser() {
        return this.authenticationContext.getUser();
    }
}

