/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.rdbms;

import com.atlassian.core.ofbiz.util.CoreTransactionUtil;
import com.atlassian.fugue.Option;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.sal.api.rdbms.ConnectionCallback;
import com.atlassian.sal.api.rdbms.RdbmsException;
import com.atlassian.sal.jira.features.JiraSalFeatureFlags;
import com.atlassian.sal.spi.HostConnectionAccessor;
import java.sql.Connection;
import java.sql.SQLException;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericTransactionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraHostConnectionAccessor
implements HostConnectionAccessor {
    private static final Logger log = LoggerFactory.getLogger(JiraHostConnectionAccessor.class);
    private static final boolean BEGAN_TRANSACTION_FALSE = false;
    private final DatabaseAccessor databaseAccessor;
    private final FeatureManager featureManager;
    private final Option<String> schemaName;

    public JiraHostConnectionAccessor(DatabaseAccessor databaseAccessor, FeatureManager featureManager) {
        this.databaseAccessor = databaseAccessor;
        this.featureManager = featureManager;
        this.schemaName = Option.option(databaseAccessor.getSchemaName().orElse(null));
    }

    public <A> A execute(boolean readOnly, boolean newTransaction, @Nonnull ConnectionCallback<A> callback) {
        try {
            if (newTransaction) {
                return this.borrowConnectionAndExecute(readOnly, callback);
            }
            if (this.featureManager.isEnabled(JiraSalFeatureFlags.HOST_CONNECT_ACCESSOR_EXISTING_TRANSACTION_WILL_CREATE_TRANSACTIONS)) {
                return this.runInStartedOrExistingTransaction(callback);
            }
            Connection existingConnection = CoreTransactionUtil.getConnection();
            if (existingConnection == null) {
                return this.borrowConnectionAndExecute(readOnly, callback);
            }
            return this.runInExistingTransaction(existingConnection, callback);
        }
        catch (RuntimeException re) {
            try {
                CoreTransactionUtil.setRollbackOnly((boolean)false);
            }
            catch (GenericTransactionException se) {
                re.addSuppressed(se);
            }
            throw re;
        }
    }

    private <A> A borrowConnectionAndExecute(boolean readOnly, ConnectionCallback<A> callback) {
        return (A)this.databaseAccessor.executeQuery(connection -> {
            connection.setAutoCommit(false);
            try {
                connection.getJdbcConnection().setReadOnly(readOnly);
            }
            catch (SQLException e) {
                throw new DataAccessException((Throwable)e);
            }
            try {
                Object result = callback.execute(connection.getJdbcConnection());
                connection.getJdbcConnection().commit();
                Object object = result;
                return object;
            }
            catch (SQLException se) {
                throw new RdbmsException("Unable to commit connection", (Throwable)se);
            }
            finally {
                if (readOnly) {
                    try {
                        connection.getJdbcConnection().setReadOnly(false);
                    }
                    catch (SQLException ex) {
                        log.error("Unable to unset the read-only flag on a borrowed DB Connection ... chaos will ensue.", (Throwable)ex);
                    }
                }
            }
        });
    }

    private <A> A runInExistingTransaction(Connection existingConnection, ConnectionCallback<A> callback) {
        try {
            return (A)callback.execute(existingConnection);
        }
        catch (RuntimeException re) {
            try {
                CoreTransactionUtil.setRollbackOnly((boolean)false);
            }
            catch (GenericTransactionException se) {
                re.addSuppressed(se);
            }
            throw re;
        }
    }

    private <A> A runInStartedOrExistingTransaction(ConnectionCallback<A> callback) {
        return (A)this.databaseAccessor.runInManagedTransaction(arg_0 -> callback.execute(arg_0));
    }

    @Nonnull
    public Option<String> getSchemaName() {
        return this.schemaName;
    }
}

