/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.pluginsettings;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.jira.pluginsettings.CacheInvalidatingPluginSettings;

class ClusterSafePluginSettings
implements PluginSettings {
    private final CacheInvalidatingPluginSettings cacheInvalidatingPluginSettings;
    private final PluginSettings defaultPluginSettings;
    private static final String AO_BUILD_NUMBER_PREFIX = "AO_";
    private static final String AO_BUILD_NUMBER_SUFFIX = "_#";

    ClusterSafePluginSettings(CacheInvalidatingPluginSettings cacheInvalidatingPluginSettings, PluginSettings defaultPluginSettings) {
        this.cacheInvalidatingPluginSettings = cacheInvalidatingPluginSettings;
        this.defaultPluginSettings = defaultPluginSettings;
    }

    public Object get(String key) {
        if (this.isAoBuildNumberProperty(key)) {
            return this.cacheInvalidatingPluginSettings.get(key);
        }
        return this.defaultPluginSettings.get(key);
    }

    private boolean isAoBuildNumberProperty(String key) {
        return key != null && key.startsWith(AO_BUILD_NUMBER_PREFIX) && key.endsWith(AO_BUILD_NUMBER_SUFFIX);
    }

    public Object put(String key, Object value) {
        return this.defaultPluginSettings.put(key, value);
    }

    public Object remove(String key) {
        return this.defaultPluginSettings.remove(key);
    }
}

