/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.sal.api.license.ProductLicense;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.atlassian.sal.jira.license.ApplicationProductLicense;
import com.atlassian.sal.jira.license.BaseLicenseDetailsImpl;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

class SingleProductLicenseDetailsViewImpl
extends BaseLicenseDetailsImpl
implements SingleProductLicenseDetailsView {
    private final ProductLicense productLicense;

    SingleProductLicenseDetailsViewImpl(@Nonnull LicenseDetails licenseDetails, @Nonnull String productKey) {
        super(licenseDetails);
        Preconditions.checkArgument((boolean)ApplicationKey.isValid((String)productKey), (Object)String.format("%s is not a valid key.", productKey));
        ApplicationKey wanted = ApplicationKey.valueOf((String)productKey);
        if (!licenseDetails.hasApplication(wanted)) {
            throw new IllegalArgumentException("No product license with key '" + wanted + "'.");
        }
        this.productLicense = new ApplicationProductLicense(wanted, licenseDetails.getLicensedApplications().getUserLimit(wanted), (com.atlassian.extras.api.ProductLicense)licenseDetails.getJiraLicense());
    }

    @Nonnull
    public String getProductKey() {
        return this.productLicense.getProductKey();
    }

    public boolean isUnlimitedNumberOfUsers() {
        return this.productLicense.isUnlimitedNumberOfUsers();
    }

    public int getNumberOfUsers() {
        return this.productLicense.getNumberOfUsers();
    }

    @Nonnull
    public String getProductDisplayName() {
        return this.productLicense.getProductDisplayName();
    }
}

