/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.extras.api.Product;
import com.atlassian.extras.api.jira.JiraLicense;
import com.atlassian.jira.license.DefaultLicensedApplications;
import com.atlassian.jira.license.LicenseDetails;
import com.atlassian.jira.license.LicensedApplications;
import com.atlassian.sal.api.license.MultiProductLicenseDetails;
import com.atlassian.sal.api.license.ProductLicense;
import com.atlassian.sal.jira.license.ApplicationProductLicense;
import com.atlassian.sal.jira.license.BaseLicenseDetailsImpl;
import com.atlassian.sal.jira.license.DefaultProductLicense;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class MultiProductLicenseDetailsImpl
extends BaseLicenseDetailsImpl
implements MultiProductLicenseDetails {
    MultiProductLicenseDetailsImpl(@Nonnull LicenseDetails licenseDetails) {
        super(licenseDetails);
    }

    @Nonnull
    public Set<ProductLicense> getProductLicenses() {
        LicenseDetails licenseDetails = this.getLicenseDetails();
        LicensedApplications licensedApps = licenseDetails.getLicensedApplications();
        Set applicationKeys = licensedApps.getKeys();
        HashSet productLicenses = Sets.newHashSetWithExpectedSize((int)applicationKeys.size());
        for (ApplicationKey application : applicationKeys) {
            productLicenses.add(new ApplicationProductLicense(application, licensedApps.getUserLimit(application), (com.atlassian.extras.api.ProductLicense)licenseDetails.getJiraLicense()));
        }
        if (productLicenses.isEmpty() && Iterables.contains((Iterable)licenseDetails.getJiraLicense().getProducts(), (Object)Product.JIRA)) {
            productLicenses.add(new DefaultProductLicense(Product.JIRA.getNamespace(), (com.atlassian.extras.api.ProductLicense)licenseDetails.getJiraLicense()));
        }
        return productLicenses;
    }

    @Nonnull
    public Set<ProductLicense> getEmbeddedLicenses() {
        HashSet<ProductLicense> otherEmbeddedLicenses = new HashSet<ProductLicense>();
        JiraLicense license = this.getJiraLicense();
        for (Product p : license.getProducts()) {
            if (p.getNamespace().startsWith(DefaultLicensedApplications.JIRA_PRODUCT_NAMESPACE) || p.equals((Object)Product.JIRA)) continue;
            otherEmbeddedLicenses.add(new DefaultProductLicense(p.getNamespace(), (com.atlassian.extras.api.ProductLicense)license));
        }
        return otherEmbeddedLicenses;
    }

    @Nullable
    public ProductLicense getProductLicense(@Nonnull String productKey) {
        for (ProductLicense productLicense : this.getProductLicenses()) {
            if (!productLicense.getProductKey().equals(productKey)) continue;
            return productLicense;
        }
        for (ProductLicense productLicense : this.getEmbeddedLicenses()) {
            if (!productLicense.getProductKey().equals(productKey)) continue;
            return productLicense;
        }
        return null;
    }
}

