/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.license;

import com.atlassian.sal.api.license.ProductLicense;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class DefaultProductLicense
implements ProductLicense {
    private final String productNamespace;
    private final com.atlassian.extras.api.ProductLicense productLicense;

    public DefaultProductLicense(@Nonnull String productNamespace, @Nonnull com.atlassian.extras.api.ProductLicense license) {
        this.productNamespace = productNamespace;
        this.productLicense = license;
    }

    @Nonnull
    public String getProductKey() {
        return this.productNamespace;
    }

    public boolean isUnlimitedNumberOfUsers() {
        return this.getNumberOfUsers() == -1;
    }

    public int getNumberOfUsers() {
        String userLimit = this.getProperty("NumberOfUsers");
        return userLimit != null ? Integer.parseInt(userLimit) : -1;
    }

    @Nonnull
    public String getProductDisplayName() {
        String desc = this.getProperty("Description");
        return desc != null ? desc : this.getProductKey();
    }

    @Nullable
    public String getProperty(@Nonnull String property) {
        return this.productLicense.getProperty(this.productNamespace + "." + property);
    }

    public final boolean equals(Object other) {
        return other instanceof ProductLicense && this.getProductKey().equals(((ProductLicense)other).getProductKey());
    }

    public final int hashCode() {
        return this.getProductKey().hashCode();
    }

    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.getProductKey());
    }
}

