/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.license;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.fugue.Option;
import com.atlassian.jira.application.ApplicationKeys;
import com.atlassian.jira.application.ApplicationRoleDefinitions;
import com.atlassian.jira.application.UndefinedApplicationRoleName;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.license.DefaultLicensedApplications;
import com.atlassian.sal.api.license.ProductLicense;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

class ApplicationProductLicense
implements ProductLicense {
    private final ApplicationKey key;
    private final int userLimit;
    private final com.atlassian.extras.api.ProductLicense license;

    ApplicationProductLicense(@Nonnull ApplicationKey key, int userLimit, @Nonnull com.atlassian.extras.api.ProductLicense license) {
        Preconditions.checkNotNull((Object)key, (Object)"key");
        if (userLimit != -1 && userLimit <= 0) {
            throw new IllegalArgumentException("Invalid userLimit of " + userLimit + " provided.");
        }
        this.key = key;
        this.userLimit = userLimit;
        this.license = license;
    }

    @Nonnull
    public String getProductKey() {
        return this.key.value();
    }

    public boolean isUnlimitedNumberOfUsers() {
        return this.userLimit == -1;
    }

    public int getNumberOfUsers() {
        return this.userLimit;
    }

    @Nonnull
    public String getProductDisplayName() {
        ApplicationRoleDefinitions roleDefinitions = (ApplicationRoleDefinitions)ComponentAccessor.getComponent(ApplicationRoleDefinitions.class);
        Option role = roleDefinitions.getDefined(this.key);
        if (role.isDefined()) {
            return ((ApplicationRoleDefinitions.ApplicationRoleDefinition)role.get()).name();
        }
        String name = this.getProperty("Description");
        if (!StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        return UndefinedApplicationRoleName.of((ApplicationKey)this.key).getName();
    }

    @Nullable
    public String getProperty(@Nonnull String property) {
        String value = this.license.getProperty(DefaultLicensedApplications.getApplicationLicensePropertyName((ApplicationKey)this.key, (String)property));
        if (value != null) {
            return value;
        }
        if (this.key.equals((Object)ApplicationKeys.SERVICE_DESK)) {
            return this.license.getProperty("com.atlassian.servicedesk." + property);
        }
        return null;
    }

    public final boolean equals(Object objectComparingTo) {
        return objectComparingTo instanceof ProductLicense && this.getProductKey().equals(((ProductLicense)objectComparingTo).getProductKey());
    }

    public final int hashCode() {
        return this.getProductKey().hashCode();
    }

    public final String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.getProductKey());
    }
}

