/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.executor;

import com.atlassian.jira.cache.JiraVCacheInitialisationUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.tenancy.JiraTenantContext;
import com.atlassian.jira.tenancy.JiraTenantImpl;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.tenancy.api.Tenant;

public class JiraThreadLocalContextManager
implements ThreadLocalContextManager<JiraThreadLocalContext> {
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final JiraTenantContext tenantContext;

    public JiraThreadLocalContextManager(JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory velocityRequestContextFactory, JiraTenantContext tenantContext) {
        this.authenticationContext = authenticationContext;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.tenantContext = tenantContext;
    }

    public JiraThreadLocalContext getThreadLocalContext() {
        return new JiraThreadLocalContext(this.authenticationContext.getUser(), this.velocityRequestContextFactory.getJiraVelocityRequestContext(), this.tenantContext.getCurrentTenant());
    }

    public void setThreadLocalContext(JiraThreadLocalContext context) {
        this.authenticationContext.setLoggedInUser(context.getUser());
        this.velocityRequestContextFactory.setVelocityRequestContext(context.getVelocityRequestContext());
        this.tenantContext.setCurrentTenant(context.getTenant());
        JiraVCacheInitialisationUtils.initVCache((JiraTenantImpl)JiraVCacheInitialisationUtils.getFakeTenant());
    }

    public void clearThreadLocalContext() {
        this.velocityRequestContextFactory.clearVelocityRequestContext();
        this.authenticationContext.clearLoggedInUser();
        this.tenantContext.clearTenant();
        JiraVCacheInitialisationUtils.cleanupVCache();
    }

    static class JiraThreadLocalContext {
        private final ApplicationUser user;
        private final VelocityRequestContext velocityRequestContext;
        private final Tenant tenant;

        private JiraThreadLocalContext(ApplicationUser user, VelocityRequestContext velocityRequestContext, Tenant tenant) {
            this.user = user;
            this.tenant = tenant;
            this.velocityRequestContext = velocityRequestContext;
        }

        public ApplicationUser getUser() {
            return this.user;
        }

        public VelocityRequestContext getVelocityRequestContext() {
            return this.velocityRequestContext;
        }

        public Tenant getTenant() {
            return this.tenant;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JiraThreadLocalContext that = (JiraThreadLocalContext)o;
            if (this.user != null ? !this.user.equals((Object)that.user) : that.user != null) {
                return false;
            }
            if (this.velocityRequestContext != null ? !this.velocityRequestContext.equals(that.velocityRequestContext) : that.velocityRequestContext != null) {
                return false;
            }
            return !(this.tenant != null ? !this.tenant.equals(that.tenant) : that.tenant != null);
        }

        public int hashCode() {
            int result = this.user != null ? this.user.hashCode() : 0;
            result = 31 * result + (this.velocityRequestContext != null ? this.velocityRequestContext.hashCode() : 0);
            result = 31 * result + (this.tenant != null ? this.tenant.hashCode() : 0);
            return result;
        }
    }
}

