/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.jira.authentication;

import com.atlassian.jira.bc.security.login.LoginService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.core.auth.SeraphAuthenticationListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JiraAuthenticationListener
extends SeraphAuthenticationListener {
    private final LoginService loginService;
    private final UserManager userManager;

    public JiraAuthenticationListener(LoginService loginService, UserManager userManager) {
        this.loginService = loginService;
        this.userManager = userManager;
    }

    public void authenticationSuccess(Authenticator.Result result, HttpServletRequest request, HttpServletResponse response) {
        super.authenticationSuccess(result, request, response);
        if (result.getPrincipal() != null) {
            ApplicationUser user = this.userManager.getUserByName(result.getPrincipal().getName());
            this.loginService.updateLastLoginTime(user);
        }
    }
}

