/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.oauth.serviceprovider;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.ofbiz.OfBizListIterator;
import com.atlassian.jira.propertyset.JiraPropertySetFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.oauth.event.AccessTokenRemovedEvent;
import com.atlassian.oauth.event.RequestTokenRemovedEvent;
import com.atlassian.oauth.serviceprovider.Clock;
import com.atlassian.oauth.serviceprovider.InvalidTokenException;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth.serviceprovider.ServiceProviderToken;
import com.atlassian.oauth.serviceprovider.ServiceProviderTokenStore;
import com.atlassian.oauth.serviceprovider.StoreException;
import com.atlassian.oauth.serviceprovider.SystemClock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.opensymphony.module.propertyset.PropertySet;
import java.net.URI;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfBizServiceProviderTokenStore
implements ServiceProviderTokenStore {
    private static final Logger log = LoggerFactory.getLogger(OfBizServiceProviderTokenStore.class);
    public static final String TABLE = "OAuthServiceProviderToken";
    public static final String PROPERTY_SET_KEY = "OAuthServiceProviderToken";
    private final OfBizDelegator delegator;
    private final UserUtil userUtil;
    private final ServiceProviderConsumerStore consumerStore;
    private final JiraPropertySetFactory propertySetFactory;
    private final Clock clock;
    private final EventPublisher eventPublisher;
    private final UserKeyService userKeyService;

    public OfBizServiceProviderTokenStore(OfBizDelegator delegator, UserUtil userUtil, ServiceProviderConsumerStore consumerStore, EventPublisher eventPublisher, JiraPropertySetFactory propertySetFactory, UserKeyService userKeyService) {
        this(delegator, userUtil, consumerStore, propertySetFactory, eventPublisher, userKeyService, (Clock)new SystemClock());
    }

    @VisibleForTesting
    public OfBizServiceProviderTokenStore(OfBizDelegator delegator, UserUtil userUtil, ServiceProviderConsumerStore consumerStore, JiraPropertySetFactory propertySetFactory, EventPublisher eventPublisher, UserKeyService userKeyService, Clock clock) {
        this.userUtil = (UserUtil)Assertions.notNull((String)"userUtil", (Object)userUtil);
        this.delegator = (OfBizDelegator)Assertions.notNull((String)"delegator", (Object)delegator);
        this.consumerStore = (ServiceProviderConsumerStore)Assertions.notNull((String)"consumerStore", (Object)consumerStore);
        this.propertySetFactory = (JiraPropertySetFactory)Assertions.notNull((String)"propertySetFactory", (Object)propertySetFactory);
        this.eventPublisher = (EventPublisher)Assertions.notNull((String)"eventPublisher", (Object)eventPublisher);
        this.clock = (Clock)Assertions.notNull((String)"clock", (Object)clock);
        this.userKeyService = userKeyService;
    }

    public ServiceProviderToken get(String token) throws StoreException {
        Assertions.notNull((String)"token", (Object)token);
        try {
            List consumerTokenGVs = this.delegator.findByAnd("OAuthServiceProviderToken", MapBuilder.newBuilder().add((Object)"token", (Object)token).toMap());
            if (!consumerTokenGVs.isEmpty()) {
                return this.createTokenFromGV((GenericValue)consumerTokenGVs.get(0));
            }
            return null;
        }
        catch (DataAccessException e) {
            throw new StoreException((Throwable)e);
        }
    }

    public Iterable<ServiceProviderToken> getAccessTokensForUser(String username) {
        List userTokenGVs;
        String userKey = this.userKeyService.getKeyForUsername(username);
        if (userKey == null) {
            throw new IllegalArgumentException("There is no user with username '" + username + "'");
        }
        try {
            userTokenGVs = this.delegator.findByAnd("OAuthServiceProviderToken", MapBuilder.newBuilder().add((Object)"username", (Object)userKey).add((Object)"tokenType", (Object)TokenType.ACCESS.toString()).toMap());
        }
        catch (DataAccessException e) {
            throw new StoreException((Throwable)e);
        }
        ArrayList<ServiceProviderToken> ret = new ArrayList<ServiceProviderToken>(userTokenGVs.size());
        for (GenericValue userTokenGV : userTokenGVs) {
            ret.add(this.createTokenFromGV(userTokenGV));
        }
        return ret;
    }

    public ServiceProviderToken put(ServiceProviderToken token) throws StoreException {
        block6: {
            Assertions.notNull((String)"token", (Object)token);
            String userKey = token.getUser() == null ? null : this.userKeyService.getKeyForUsername(token.getUser().getName());
            Map fieldValues = MapBuilder.newBuilder().add((Object)"created", (Object)new Timestamp(token.getCreationTime())).add((Object)"token", (Object)token.getToken()).add((Object)"tokenSecret", (Object)token.getTokenSecret()).add((Object)"tokenType", (Object)(token.isAccessToken() ? TokenType.ACCESS.toString() : TokenType.REQUEST.toString())).add((Object)"consumerKey", (Object)token.getConsumer().getKey()).add((Object)"username", (Object)userKey).add((Object)"auth", token.getAuthorization() == null ? null : token.getAuthorization().toString()).add((Object)"ttl", (Object)token.getTimeToLive()).add((Object)"verifier", (Object)token.getVerifier()).add((Object)"callback", token.getCallback() == null ? null : token.getCallback().toASCIIString()).add((Object)"version", token.getVersion() == null ? null : token.getVersion().toString()).toMutableMap();
            ServiceProviderToken.Session session = token.getSession();
            if (session != null) {
                fieldValues.put("sessionHandle", session.getHandle());
                fieldValues.put("sessionCreationTime", new Timestamp(session.getCreationTime()));
                fieldValues.put("sessionLastRenewalTime", new Timestamp(session.getLastRenewalTime()));
                fieldValues.put("sessionTimeToLive", new Timestamp(session.getTimeToLive()));
            }
            try {
                List consumerTokenGVs = this.delegator.findByAnd("OAuthServiceProviderToken", MapBuilder.newBuilder().add((Object)"token", (Object)token.getToken()).toMap());
                if (!consumerTokenGVs.isEmpty()) {
                    GenericValue gv = (GenericValue)consumerTokenGVs.get(0);
                    gv.setNonPKFields(fieldValues);
                    try {
                        gv.store();
                        this.setTokenProperties(gv.getLong("id"), token.getProperties());
                        break block6;
                    }
                    catch (GenericEntityException e) {
                        throw new DataAccessException((Throwable)e);
                    }
                }
                GenericValue gv = this.delegator.createValue("OAuthServiceProviderToken", fieldValues);
                this.setTokenProperties(gv.getLong("id"), token.getProperties());
            }
            catch (DataAccessException e) {
                throw new StoreException((Throwable)e);
            }
        }
        return this.get(token.getToken());
    }

    public void removeAndNotify(String token) throws StoreException {
        ServiceProviderToken removedToken = this.remove(token);
        if (removedToken != null) {
            this.publishRemovedTokenEvent(removedToken);
        }
    }

    @Nullable
    protected final ServiceProviderToken remove(String token) throws StoreException {
        Assertions.notNull((String)"token", (Object)token);
        try {
            List consumerTokenGVs = this.delegator.findByAnd("OAuthServiceProviderToken", MapBuilder.newBuilder().add((Object)"token", (Object)token).toMap());
            if (!consumerTokenGVs.isEmpty()) {
                GenericValue tokenGv = (GenericValue)consumerTokenGVs.get(0);
                Long tokenId = tokenGv.getLong("id");
                this.delegator.removeValue(tokenGv);
                this.setTokenProperties(tokenId, Collections.emptyMap());
                return this.createTokenFromGV(tokenGv);
            }
            return null;
        }
        catch (DataAccessException e) {
            throw new StoreException((Throwable)e);
        }
    }

    public void removeExpiredTokensAndNotify() throws StoreException {
        List<ServiceProviderToken> removedTokens = this.removeExpiredTokens();
        for (ServiceProviderToken removedToken : removedTokens) {
            this.publishRemovedTokenEvent(removedToken);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final List<ServiceProviderToken> removeExpiredTokens() throws StoreException {
        OfBizListIterator allTokens = this.delegator.findListIteratorByCondition("OAuthServiceProviderToken", null);
        ArrayList removedTokens = Lists.newArrayList();
        ArrayList idsToRemove = Lists.newArrayList();
        try {
            for (GenericValue tokenGV : allTokens) {
                ServiceProviderToken token = this.createTokenFromGV(tokenGV);
                if (token.getSession() != null || !token.hasExpired(this.clock)) continue;
                idsToRemove.add(tokenGV.getLong("id"));
                removedTokens.add(token);
            }
        }
        finally {
            allTokens.close();
        }
        this.removeByIds(idsToRemove);
        return removedTokens;
    }

    public void removeExpiredSessionsAndNotify() throws StoreException {
        this.removeExpiredSessions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeExpiredSessions() throws StoreException {
        ArrayList idsToRemove = Lists.newArrayList();
        try (OfBizListIterator allTokens = this.delegator.findListIteratorByCondition("OAuthServiceProviderToken", null);){
            for (GenericValue tokenGV : allTokens) {
                ServiceProviderToken token = this.createTokenFromGV(tokenGV);
                ServiceProviderToken.Session session = token.getSession();
                if (session == null || !session.hasExpired(this.clock)) continue;
                idsToRemove.add(tokenGV.getLong("id"));
            }
        }
        this.removeByIds(idsToRemove);
    }

    public void removeByConsumer(String consumerKey) {
        Assertions.notNull((String)"consumerKey", (Object)consumerKey);
        try {
            this.delegator.removeByAnd("OAuthServiceProviderToken", MapBuilder.newBuilder().add((Object)"consumerKey", (Object)consumerKey).toMap());
        }
        catch (DataAccessException e) {
            throw new StoreException((Throwable)e);
        }
    }

    protected void removeByIds(List<Long> idsToRemove) {
        try {
            int rowsRemoved = this.delegator.removeByOr("OAuthServiceProviderToken", "id", idsToRemove);
            if (log.isDebugEnabled()) {
                log.debug("Successfully removed " + rowsRemoved + " expired tokens.");
            }
        }
        catch (GenericModelException e) {
            throw new StoreException((Throwable)e);
        }
        catch (DataAccessException e) {
            throw new StoreException((Throwable)e);
        }
    }

    private ServiceProviderToken createTokenFromGV(GenericValue gv) {
        boolean isAccessToken = this.isAccessToken(gv.getString("tokenType"));
        String token = gv.getString("token");
        Principal user = this.getUser(gv.getString("username"));
        if (user == null && isAccessToken) {
            throw new InvalidTokenException("Token '" + token + "' is an access token, but has no user associated with it");
        }
        if (isAccessToken) {
            ServiceProviderToken.ServiceProviderTokenBuilder builder = ((ServiceProviderToken.ServiceProviderTokenBuilder)((ServiceProviderToken.ServiceProviderTokenBuilder)((ServiceProviderToken.ServiceProviderTokenBuilder)ServiceProviderToken.newAccessToken((String)token).tokenSecret(gv.getString("tokenSecret"))).consumer(this.consumerStore.get(gv.getString("consumerKey")))).authorizedBy(user).creationTime(gv.getTimestamp("created").getTime()).timeToLive(gv.getLong("ttl").longValue()).properties(this.getTokenProperties(gv.getLong("id")))).version(this.getVersion(gv.getString("version")));
            if (gv.getString("sessionHandle") != null) {
                builder = builder.session(ServiceProviderToken.Session.newSession((String)gv.getString("sessionHandle")).creationTime(gv.getTimestamp("sessionCreationTime").getTime()).lastRenewalTime(gv.getTimestamp("sessionLastRenewalTime").getTime()).timeToLive(gv.getTimestamp("sessionTimeToLive").getTime()).build());
            }
            return builder.build();
        }
        String callBackUriString = gv.getString("callback");
        URI callbackURI = null;
        if (StringUtils.isNotBlank((String)callBackUriString)) {
            callbackURI = URI.create(callBackUriString);
        }
        ServiceProviderToken.ServiceProviderTokenBuilder builder = (ServiceProviderToken.ServiceProviderTokenBuilder)((ServiceProviderToken.ServiceProviderTokenBuilder)((ServiceProviderToken.ServiceProviderTokenBuilder)ServiceProviderToken.newRequestToken((String)token).tokenSecret(gv.getString("tokenSecret"))).consumer(this.consumerStore.get(gv.getString("consumerKey")))).callback(callbackURI).creationTime(gv.getTimestamp("created").getTime()).timeToLive(gv.getLong("ttl").longValue()).version(this.getVersion(gv.getString("version"))).properties(this.getTokenProperties(gv.getLong("id")));
        ServiceProviderToken.Authorization authorization = this.getAuthorization(gv.getString("auth"), user);
        if (ServiceProviderToken.Authorization.AUTHORIZED.equals((Object)authorization)) {
            builder = builder.authorizedBy(user).verifier(gv.getString("verifier"));
        } else if (ServiceProviderToken.Authorization.DENIED.equals((Object)authorization)) {
            builder = builder.deniedBy(user);
        }
        return builder.build();
    }

    private ServiceProviderToken.Version getVersion(String versionString) {
        if (StringUtils.isBlank((String)versionString)) {
            return null;
        }
        return ServiceProviderToken.Version.valueOf((String)versionString);
    }

    private ServiceProviderToken.Authorization getAuthorization(String authorization, Principal user) {
        if (authorization != null) {
            return ServiceProviderToken.Authorization.valueOf((String)authorization);
        }
        return user != null ? ServiceProviderToken.Authorization.AUTHORIZED : ServiceProviderToken.Authorization.NONE;
    }

    Principal getUser(String userKey) {
        ApplicationUser userByKey = this.userUtil.getUserByKey(userKey);
        return userByKey == null ? null : userByKey.getDirectoryUser();
    }

    private Map<String, String> getTokenProperties(Long tokenId) {
        PropertySet propertySet = this.propertySetFactory.buildCachingPropertySet("OAuthServiceProviderToken", tokenId, true);
        MapBuilder ret = MapBuilder.newBuilder();
        Collection keys = propertySet.getKeys();
        for (String key : keys) {
            ret.add((Object)key, (Object)propertySet.getText(key));
        }
        return ret.toMap();
    }

    @GuardedBy(value="external-lock")
    private void setTokenProperties(Long tokenId, Map<String, String> props) {
        PropertySet propertySet = this.propertySetFactory.buildCachingPropertySet("OAuthServiceProviderToken", tokenId, true);
        Collection keys = propertySet.getKeys();
        for (String key : keys) {
            propertySet.remove(key);
        }
        Set<Map.Entry<String, String>> entries = props.entrySet();
        for (Map.Entry<String, String> prop : entries) {
            propertySet.setText(prop.getKey(), prop.getValue());
        }
    }

    private boolean isAccessToken(String tokenType) {
        return TokenType.ACCESS.equals((Object)TokenType.valueOf(tokenType));
    }

    private void publishRemovedTokenEvent(@Nonnull ServiceProviderToken removedToken) {
        Principal user = removedToken.getUser();
        String username = user != null ? user.getName() : null;
        this.eventPublisher.publish(removedToken.isAccessToken() ? new AccessTokenRemovedEvent(username) : new RequestTokenRemovedEvent(username));
    }

    static enum TokenType {
        ACCESS,
        REQUEST;

    }

    static final class Columns {
        static final String ID = "id";
        static final String CREATED = "created";
        static final String TOKEN = "token";
        static final String TOKEN_SECRET = "tokenSecret";
        static final String TYPE = "tokenType";
        static final String CONSUMER_KEY = "consumerKey";
        static final String USERNAME = "username";
        static final String TTL = "ttl";
        static final String AUTHORIZATION = "auth";
        static final String CALLBACK = "callback";
        static final String VERIFIER = "verifier";
        static final String VERSION = "version";
        static final String SESSION_HANDLE = "sessionHandle";
        static final String SESSION_CREATION_TIME = "sessionCreationTime";
        static final String SESSION_LAST_RENEWAL_TIME = "sessionLastRenewalTime";
        static final String SESSION_TIME_TO_LIVE = "sessionTimeToLive";

        Columns() {
        }
    }
}

