/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.extra.icalfeed.service;

import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.query.Query;
import java.text.ParseException;
import java.util.Collection;
import org.joda.time.DateTime;

public interface EntityAsEventService {
    public Result search(Query var1, Collection<String> var2, Collection<Duration> var3, boolean var4, ApplicationUser var5, long var6, long var8, int var10) throws SearchException, ParseException;

    public static interface DurationReinterpreter {
        public DateTime reinterpretStartDate(DateTime var1, DateTime var2);

        public DateTime reinterpretEndDate(DateTime var1, DateTime var2);
    }

    public static class DurationIssueResult
    extends IssueDateResult {
        public final String startDateFieldKey;
        public final String startDateFieldName;
        public final String endDateFieldKey;
        public final String endDateFieldName;

        public DurationIssueResult(ApplicationUser assignee, boolean allDay, String issueKey, String issueSummary, String issueDescription, String type, String typeIconUrl, String status, String resolution, String statusIconUrl, DateTime issueCreated, DateTime issueUpdated, DateTime start, DateTime end, String startDateFieldKey, String startDateFieldName, String endDateFieldKey, String endDateFieldName) {
            super(assignee, allDay, issueKey, issueSummary, issueDescription, type, typeIconUrl, status, resolution, statusIconUrl, issueCreated, issueUpdated, start, end);
            this.startDateFieldKey = startDateFieldKey;
            this.startDateFieldName = startDateFieldName;
            this.endDateFieldKey = endDateFieldKey;
            this.endDateFieldName = endDateFieldName;
        }
    }

    public static class SingleDateIssueResult
    extends IssueDateResult {
        public final String dateFieldKey;
        public final String dateFieldName;

        public SingleDateIssueResult(ApplicationUser assignee, boolean allDay, String issueKey, String issueSummary, String issueDescription, String type, String typeIconUrl, String status, String rawStatus, String statusIconUrl, DateTime issueCreated, DateTime issueUpdated, DateTime start, DateTime end, String dateFieldKey, String dateFieldName) {
            super(assignee, allDay, issueKey, issueSummary, issueDescription, type, typeIconUrl, status, rawStatus, statusIconUrl, issueCreated, issueUpdated, start, end);
            this.dateFieldKey = dateFieldKey;
            this.dateFieldName = dateFieldName;
        }
    }

    public static abstract class IssueDateResult {
        public final ApplicationUser assignee;
        public final boolean allDay;
        public final String issueKey;
        public final String issueSummary;
        public final String issueDescription;
        public final String type;
        public final String typeIconUrl;
        public final String status;
        public final String resolution;
        public final String statusIconUrl;
        public final DateTime issueCreated;
        public final DateTime issueUpdated;
        public final DateTime start;
        public final DateTime end;

        public IssueDateResult(ApplicationUser assignee, boolean allDay, String issueKey, String issueSummary, String issueDescription, String type, String typeIconUrl, String status, String resolution, String statusIconUrl, DateTime issueCreated, DateTime issueUpdated, DateTime start, DateTime end) {
            this.assignee = assignee;
            this.allDay = allDay;
            this.issueKey = issueKey;
            this.issueSummary = issueSummary;
            this.issueDescription = issueDescription;
            this.type = type;
            this.typeIconUrl = typeIconUrl;
            this.status = status;
            this.resolution = resolution;
            this.statusIconUrl = statusIconUrl;
            this.issueCreated = issueCreated;
            this.issueUpdated = issueUpdated;
            this.start = start;
            this.end = end;
        }
    }

    public static class Result {
        public final Collection<IssueDateResult> issues;
        public final Collection<Version> affectedVersions;
        public final Collection<Version> fixedVersions;

        public Result(Collection<IssueDateResult> issues, Collection<Version> affectedVersions, Collection<Version> fixedVersions) {
            this.issues = issues;
            this.affectedVersions = affectedVersions;
            this.fixedVersions = fixedVersions;
        }
    }

    public static class Duration {
        private String startDateFieldKey;
        private String endDateFieldKey;

        public Duration(String startDateFieldKey, String endDateFieldKey) {
            this.startDateFieldKey = startDateFieldKey;
            this.endDateFieldKey = endDateFieldKey;
        }

        public String getStartDateFieldKey() {
            return this.startDateFieldKey;
        }

        public String getEndDateFieldKey() {
            return this.endDateFieldKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Duration duration = (Duration)o;
            if (this.endDateFieldKey != null ? !this.endDateFieldKey.equals(duration.endDateFieldKey) : duration.endDateFieldKey != null) {
                return false;
            }
            return !(this.startDateFieldKey != null ? !this.startDateFieldKey.equals(duration.startDateFieldKey) : duration.startDateFieldKey != null);
        }

        public int hashCode() {
            int result = this.startDateFieldKey != null ? this.startDateFieldKey.hashCode() : 0;
            result = 31 * result + (this.endDateFieldKey != null ? this.endDateFieldKey.hashCode() : 0);
            return result;
        }
    }
}

