/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.user;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Function2;
import com.atlassian.jira.bc.user.UserPropertyService;
import com.atlassian.jira.entity.property.EntityPropertyType;
import com.atlassian.jira.issue.fields.rest.json.beans.EntityPropertyBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.rest.util.ResponseFactory;
import com.atlassian.jira.rest.util.SelfLinkBuilder;
import com.atlassian.jira.rest.v2.entity.property.BasePropertyResource;
import com.atlassian.jira.rest.v2.entity.property.EntityPropertiesKeysBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserIdentity;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.ErrorCollections;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.rest.annotation.ResponseType;
import com.google.common.base.Function;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="user/properties/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class UserPropertyResource {
    private final BasePropertyResource<ApplicationUser> delegate;
    private final I18nHelper i18n;
    private final ResponseFactory responseFactory;
    private final UserManager userManager;
    private final SelfLinkBuilder.SelfLink selfLink;

    protected UserPropertyResource(UserPropertyService userPropertyService, JiraAuthenticationContext authenticationContext, JiraBaseUrls jiraBaseUrls, I18nHelper i18n, ResponseFactory responseFactory, UserManager userManager, SelfLinkBuilder selfLinkBuilder) {
        this.responseFactory = responseFactory;
        this.userManager = userManager;
        this.selfLink = selfLinkBuilder.path("user/properties/");
        this.delegate = new BasePropertyResource(userPropertyService, authenticationContext, jiraBaseUrls, i18n, new Function2<Long, String, String>(){

            public String apply(Long userId, String propertyKey) {
                return UserPropertyResource.this.getSelf(userId, propertyKey);
            }
        }, EntityPropertyType.COMMENT_PROPERTY);
        this.i18n = i18n;
    }

    private String getSelf(Long userId, String propertyKey) {
        return this.selfLink.path(propertyKey, new String[0]).queryParam("userKey", ((UserIdentity)this.userManager.getUserIdentityById(userId).get()).getKey()).toString();
    }

    @GET
    @ResponseType(value=EntityPropertiesKeysBean.class)
    public Response getPropertiesKeys(@QueryParam(value="userKey") String userKey, @QueryParam(value="username") String username) {
        return (Response)this.withUserId(userKey, username).left().on((Function)new Function<String, Response>(){

            public Response apply(String input) {
                return UserPropertyResource.this.delegate.getPropertiesKeys(input);
            }
        });
    }

    @PUT
    @Path(value="/{propertyKey}")
    @ResponseType(value=Void.class)
    public Response setProperty(@QueryParam(value="userKey") String userKey, @QueryParam(value="username") String username, final @PathParam(value="propertyKey") String propertyKey, final @Context HttpServletRequest request) {
        return (Response)this.withUserId(userKey, username).left().on((Function)new Function<String, Response>(){

            public Response apply(String input) {
                return UserPropertyResource.this.delegate.setProperty(input, propertyKey, request);
            }
        });
    }

    @GET
    @Path(value="/{propertyKey}")
    @ResponseType(value=EntityPropertyBean.class)
    public Response getProperty(@QueryParam(value="userKey") String userKey, @QueryParam(value="username") String username, final @PathParam(value="propertyKey") String propertyKey) {
        return (Response)this.withUserId(userKey, username).left().on((Function)new Function<String, Response>(){

            public Response apply(String input) {
                return UserPropertyResource.this.delegate.getProperty(input, propertyKey);
            }
        });
    }

    @DELETE
    @Path(value="/{propertyKey}")
    public Response deleteProperty(@QueryParam(value="userKey") String userKey, @QueryParam(value="username") String username, final @PathParam(value="propertyKey") String propertyKey) {
        return (Response)this.withUserId(userKey, username).left().on((Function)new Function<String, Response>(){

            public Response apply(String input) {
                return UserPropertyResource.this.delegate.deleteProperty(input, propertyKey);
            }
        });
    }

    private Either<Response, String> withUserId(String userKey, String username) {
        if (username == null == (userKey == null)) {
            return Either.left((Object)this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.user.properties.id.not.specified"), (ErrorCollection.Reason)ErrorCollection.Reason.VALIDATION_FAILED)));
        }
        Optional userIdentity = username != null ? this.userManager.getUserIdentityByUsername(username) : this.userManager.getUserIdentityByKey(userKey);
        return userIdentity.isPresent() ? Either.right((Object)((UserIdentity)userIdentity.get()).getId().toString()) : Either.left((Object)this.responseFactory.errorResponse(ErrorCollections.create((String)this.i18n.getText("rest.user.error.not.found.general"), (ErrorCollection.Reason)ErrorCollection.Reason.NOT_FOUND)));
    }
}

