/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.gzipfilter.org.apache.commons.lang.StringUtils;
import com.atlassian.jira.issue.search.jql.LastJqlFieldsService;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.internal.jql.FieldAndPredicateAutoCompleteResultGenerator;
import com.atlassian.jira.rest.v1.util.CacheControl;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.web.component.jql.AutoCompleteJsonGenerator;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.rest.annotation.ResponseType;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Locale;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="jql/autocompletedata")
@AnonymousAllowed
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class SearchAutoCompleteResource {
    public static final Logger log = LoggerFactory.getLogger(SearchAutoCompleteResource.class);
    public static final String DOC_EXAMPLE = "{\"visibleFieldNames\": [{\"value\":\"affectedVersion\",\"displayName\":\"affectedVersion\",\"auto\":\"true\",\"orderable\":\"true\",\"searchable\":\"true\",\"operators\":[\"=\",\"!=\",\"in\",\"not in\",\"is\",\"is not\",\"<\",\"<=\",\">\",\">=\"],\"types\":[\"com.atlassian.jira.project.version.Version\"]},{\"value\":\"assignee\",\"displayName\":\"assignee\",\"auto\":\"true\",\"orderable\":\"true\",\"searchable\":\"true\",\"operators\":[\"!=\",\"was not in\",\"not in\",\"was not\",\"is\",\"was in\",\"was\",\"=\",\"in\",\"changed\",\"is not\"],\"types\":[\"com.atlassian.crowd.embedded.api.User\"]}],\"visibleFunctionNames\": {\"value\":\"currentLogin()\",\"displayName\":\"currentLogin()\",\"types\":[\"java.util.Date\"]},{\"value\":\"currentUser()\",\"displayName\":\"currentUser()\",\"types\":[\"com.atlassian.crowd.embedded.api.User\"]}],\"jqlReservedWords\": \"empty\",\"and\",\"or\",\"in\",\"distinct\"]}";
    public static final AutoCompleteResultWrapper SUGGESTIONS_DOC_EXAMPLE = AutoCompleteResultWrapper.wrap((ImmutableList<FieldAndPredicateAutoCompleteResultGenerator.Result>)ImmutableList.of((Object)new FieldAndPredicateAutoCompleteResultGenerator.Result("ActiveObjects", "<b>Ac</b>tiveObjects (AO)"), (Object)new FieldAndPredicateAutoCompleteResultGenerator.Result("Atlassian Connect", "Atlassian Connect (<b>AC</b>)"), (Object)new FieldAndPredicateAutoCompleteResultGenerator.Result("Atlassian Connect in JIRA", "Atlassian Connect in JIRA (<b>AC</b>JIRA)")));
    private final AutoCompleteJsonGenerator autoCompleteJsonGenerator;
    private final JiraAuthenticationContext authContext;
    private final I18nHelper i18n;
    private final FieldAndPredicateAutoCompleteResultGenerator fieldAndPredicateAutoCompleteResultGenerator;
    private final LastJqlFieldsService lastJqlFieldsService;

    public SearchAutoCompleteResource(AutoCompleteJsonGenerator autoCompleteJsonGenerator, JiraAuthenticationContext authContext, I18nHelper i18n, FieldAndPredicateAutoCompleteResultGenerator fieldAndPredicateAutoCompleteResultGenerator, LastJqlFieldsService lastJqlFieldsService) {
        this.autoCompleteJsonGenerator = autoCompleteJsonGenerator;
        this.authContext = authContext;
        this.i18n = i18n;
        this.fieldAndPredicateAutoCompleteResultGenerator = fieldAndPredicateAutoCompleteResultGenerator;
        this.lastJqlFieldsService = lastJqlFieldsService;
    }

    @GET
    @ResponseType(value=AutoCompleteResponseBean.class)
    public Response getAutoComplete() {
        ApplicationUser user = this.authContext.getLoggedInUser();
        Locale locale = this.authContext.getLocale();
        try {
            String entity = "{\"visibleFieldNames\": " + this.autoCompleteJsonGenerator.getVisibleFieldNamesJson(user, locale) + ",\"visibleFunctionNames\": " + this.autoCompleteJsonGenerator.getVisibleFunctionNamesJson(user, locale) + ",\"jqlReservedWords\": " + this.autoCompleteJsonGenerator.getJqlReservedWordsJson() + "}";
            return Response.ok((Object)entity).cacheControl(com.atlassian.jira.rest.api.http.CacheControl.never()).build();
        }
        catch (JSONException e) {
            throw new RESTException(ErrorCollection.of(this.i18n.getText("rest.error.generating.response")).reason(ErrorCollection.Reason.SERVER_ERROR));
        }
    }

    @Path(value="suggestions")
    @GET
    @ResponseType(value=AutoCompleteResultWrapper.class)
    public Response getFieldAutoCompleteForQueryString(@QueryParam(value="fieldName") String fieldName, @QueryParam(value="fieldValue") String fieldValue, @QueryParam(value="predicateName") String predicateName, @QueryParam(value="predicateValue") String predicateValue) {
        ImmutableList.Builder results = ImmutableList.builder();
        if (fieldName != null) {
            results.addAll(this.fieldAndPredicateAutoCompleteResultGenerator.getAutoCompleteResultsForField(fieldName, StringUtils.defaultIfEmpty((String)fieldValue, (String)"")));
            ApplicationUser user = this.authContext.getLoggedInUser();
            try {
                if (user != null) {
                    this.lastJqlFieldsService.addOneField(user, fieldName);
                }
            }
            catch (JSONException e) {
                log.warn("Error during saving of new recent field '{}' for user {}", new Object[]{fieldName, user.getUsername(), e});
            }
        }
        if (predicateName != null) {
            results.addAll(this.fieldAndPredicateAutoCompleteResultGenerator.getAutoCompleteResultsForPredicate(predicateName, predicateValue, fieldName));
        }
        return Response.ok((Object)AutoCompleteResultWrapper.wrap((ImmutableList<FieldAndPredicateAutoCompleteResultGenerator.Result>)results.build())).cacheControl(CacheControl.NO_CACHE).build();
    }

    @JsonAutoDetect
    private static class AutoCompleteResponseBean {
        public List<String> visibleFieldNames;
        public List<String> visibleFunctionNames;
        public List<String> jqlReservedWords;

        private AutoCompleteResponseBean() {
        }
    }

    @XmlRootElement
    public static class AutoCompleteResultBean {
        @XmlElement
        private String value;
        @XmlElement
        private String displayName;

        public AutoCompleteResultBean(String value, String displayName) {
            this.value = value;
            this.displayName = displayName;
        }
    }

    public static class AutoCompleteResultWrapper {
        @XmlElement
        private List<AutoCompleteResultBean> results;

        public AutoCompleteResultWrapper(Iterable<AutoCompleteResultBean> results) {
            this.results = ImmutableList.copyOf(results);
        }

        public static AutoCompleteResultWrapper wrap(ImmutableList<FieldAndPredicateAutoCompleteResultGenerator.Result> results) {
            return new AutoCompleteResultWrapper(Iterables.transform(results, (Function)new Function<FieldAndPredicateAutoCompleteResultGenerator.Result, AutoCompleteResultBean>(){

                public AutoCompleteResultBean apply(FieldAndPredicateAutoCompleteResultGenerator.Result result) {
                    return new AutoCompleteResultBean(result.getValue(), result.getDisplayName());
                }
            }));
        }
    }
}

