/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.search;

import com.atlassian.jira.bc.filter.FilterSubscriptionService;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.rest.v2.issue.UserBean;
import com.atlassian.jira.rest.v2.issue.UserBeanBuilder;
import com.atlassian.jira.rest.v2.search.FilterBean;
import com.atlassian.jira.rest.v2.search.FilterPermissionBeanFactory;
import com.atlassian.jira.rest.v2.search.FilterResource;
import com.atlassian.jira.rest.v2.search.FilterSubscriptionBeanListWrapper;
import com.atlassian.jira.rest.v2.search.SearchResource;
import com.atlassian.jira.rest.v2.search.UserBeanListWrapper;
import com.atlassian.jira.rest.v2.search.UserListResolver;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.user.util.UserUtil;
import java.net.URI;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.ws.rs.core.UriInfo;

public class FilterBeanBuilder {
    private final JiraAuthenticationContext authContext;
    private final ProjectManager projectManager;
    private final PermissionManager permissionManager;
    private final ProjectRoleManager projectRoleManager;
    private final UserManager userManager;
    private final JqlStringSupport jqlStringSupport;
    private final GroupManager groupManager;
    private final SchemeManager schemeManager;
    private final FilterSubscriptionService filterSubscriptionService;
    private final JiraBaseUrls jiraBaseUrls;
    private final UserUtil userUtil;
    private final FeatureManager featureManager;
    private final FilterPermissionBeanFactory filterPermissionBeanFactory;
    private SearchRequest filter;
    private UriInfo context;
    private String canoncialBaseUrl;
    private Boolean enableSharedUsers = true;
    private ApplicationUser owner = null;
    private boolean favourite = false;

    public FilterBeanBuilder(JiraAuthenticationContext authContext, ProjectManager projectManager, PermissionManager permissionManager, ProjectRoleManager projectRoleManager, UserManager userManager, JqlStringSupport jqlStringSupport, GroupManager groupManager, SchemeManager schemeManager, FilterSubscriptionService filterSubscriptionService, JiraBaseUrls jiraBaseUrls, UserUtil userUtil, FeatureManager featureManager, FilterPermissionBeanFactory filterPermissionBeanFactory) {
        this.authContext = authContext;
        this.projectManager = projectManager;
        this.permissionManager = permissionManager;
        this.projectRoleManager = projectRoleManager;
        this.userManager = userManager;
        this.jqlStringSupport = jqlStringSupport;
        this.groupManager = groupManager;
        this.schemeManager = schemeManager;
        this.filterSubscriptionService = filterSubscriptionService;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userUtil = userUtil;
        this.featureManager = featureManager;
        this.filterPermissionBeanFactory = filterPermissionBeanFactory;
    }

    public FilterBeanBuilder filter(SearchRequest filter) {
        this.filter = filter;
        return this;
    }

    public FilterBeanBuilder context(UriInfo context, String canoncialBaseUrl) {
        this.context = context;
        this.canoncialBaseUrl = canoncialBaseUrl;
        return this;
    }

    public FilterBeanBuilder owner(ApplicationUser owner) {
        this.owner = owner;
        return this;
    }

    public FilterBeanBuilder favourite(boolean favourite) {
        this.favourite = favourite;
        return this;
    }

    public FilterBeanBuilder enableSharedUsers(boolean enableSharedUsers) {
        this.enableSharedUsers = enableSharedUsers;
        return this;
    }

    public FilterBean build() {
        if (this.filter != null) {
            if (this.context == null || this.canoncialBaseUrl == null) {
                throw new IllegalStateException("No context set.");
            }
            UserBean owner = new UserBeanBuilder(this.jiraBaseUrls).user(this.owner).buildShort();
            URI issueNavUri = URI.create(this.canoncialBaseUrl + "/issues/?filter=" + this.filter.getId());
            URI self = this.context.getBaseUriBuilder().path(FilterResource.class).path(Long.toString(this.filter.getId())).build(new Object[0]);
            String JQL = this.jqlStringSupport.generateJqlString(this.filter.getQuery());
            URI searchUri = this.context.getBaseUriBuilder().path(SearchResource.class).queryParam("jql", new Object[]{"{0}"}).build(new Object[]{JQL});
            Collection sharePermissions = StreamSupport.stream(this.filter.getPermissions().spliterator(), false).map(sharePermission -> this.filterPermissionBeanFactory.buildPermissionBean(this.authContext.getLoggedInUser(), (SharePermission)sharePermission)).collect(Collectors.toList());
            FilterSubscriptionBeanListWrapper filterSubscribtionBeanListWrapper = new FilterSubscriptionBeanListWrapper(this.filterSubscriptionService, this.userManager, this.authContext.getUser(), this.filter, this.jiraBaseUrls);
            UserListResolver userListResolver = new UserListResolver(this.authContext, this.userManager, this.groupManager, this.projectManager, this.permissionManager, this.projectRoleManager, this.schemeManager, this.userUtil, this.featureManager, sharePermissions);
            UserBeanListWrapper userBeanListWrapper = null;
            if (this.enableSharedUsers.booleanValue()) {
                userBeanListWrapper = new UserBeanListWrapper(this.jiraBaseUrls, userListResolver, 1000);
            }
            return new FilterBean(self, Long.toString(this.filter.getId()), this.filter.getName(), this.filter.getDescription(), owner, JQL, issueNavUri, searchUri, this.favourite, sharePermissions, filterSubscribtionBeanListWrapper, userBeanListWrapper);
        }
        return null;
    }
}

