/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.monitoring;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.monitoring.jmx.JmxMetricsExposer;
import com.atlassian.jira.monitoring.jmx.analytics.JmxStartExposingAnalyticsEvent;
import com.atlassian.jira.monitoring.jmx.analytics.JmxStopExposingAnalyticsEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.rest.annotation.ResponseType;
import java.util.function.Supplier;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="monitoring/jmx")
public class JmxMonitoringController {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final GlobalPermissionManager permissionManager;
    private final JmxMetricsExposer jmxMetricsExposer;
    private final EventPublisher eventPublisher;

    protected JmxMonitoringController(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport GlobalPermissionManager permissionManager, @ComponentImport JmxMetricsExposer jmxMetricsExposer, @ComponentImport EventPublisher eventPublisher) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
        this.jmxMetricsExposer = jmxMetricsExposer;
        this.eventPublisher = eventPublisher;
    }

    @GET
    @Path(value="startExposing")
    @Produces(value={"application/json"})
    @ResponseType(value=Response.class)
    public Response start() {
        return this.onlyAsAdmin(() -> {
            this.eventPublisher.publish((Object)new JmxStartExposingAnalyticsEvent());
            this.jmxMetricsExposer.startExposing();
            this.jmxMetricsExposer.publishRefreshMessage();
            return Response.ok().build();
        });
    }

    @GET
    @Path(value="stopExposing")
    @Produces(value={"application/json"})
    @ResponseType(value=Response.class)
    public Response stop() {
        return this.onlyAsAdmin(() -> {
            this.eventPublisher.publish((Object)new JmxStopExposingAnalyticsEvent());
            this.jmxMetricsExposer.stopExposing();
            this.jmxMetricsExposer.publishRefreshMessage();
            return Response.ok().build();
        });
    }

    @GET
    @Path(value="getAvailableMetrics")
    @Produces(value={"application/json"})
    @ResponseType(value=Response.class)
    public Response getAvailableMetrics() {
        return this.onlyAsAdmin(() -> Response.ok((Object)this.jmxMetricsExposer.getExposedMetricNames()).build());
    }

    @GET
    @Path(value="areMetricsExposed")
    @Produces(value={"application/json"})
    @ResponseType(value=Response.class)
    public Response areMetricsExposed() {
        return this.onlyAsAdmin(() -> Response.ok((Object)this.jmxMetricsExposer.isJmxEnabled()).build());
    }

    private Response onlyAsAdmin(Supplier<Response> runOnlyAsAdmin) {
        ApplicationUser user = this.jiraAuthenticationContext.getLoggedInUser();
        if (this.permissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user)) {
            return runOnlyAsAdmin.get();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }
}

