/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.watcher;

import com.atlassian.jira.bc.issue.watcher.WatcherService;
import com.atlassian.jira.bc.issue.watcher.WatchingDisabledException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.rest.json.UserBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.UserJsonBean;
import com.atlassian.jira.rest.v2.issue.IssueResource;
import com.atlassian.jira.rest.v2.issue.WatchersBean;
import com.atlassian.jira.rest.v2.issue.context.ContextUriInfo;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.lang.Pair;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WatchersFinder {
    private final Logger log = LoggerFactory.getLogger(WatchersFinder.class);
    private final WatcherService watcherService;
    private final ContextUriInfo uriInfo;
    private final UserBeanFactory userBeanFactory;

    WatchersFinder(WatcherService watcherService, ContextUriInfo uriInfo, UserBeanFactory userBeanFactory) {
        this.watcherService = watcherService;
        this.uriInfo = uriInfo;
        this.userBeanFactory = userBeanFactory;
    }

    public WatchersBean getWatchers(Issue issue, ApplicationUser callingUser) {
        return this.buildBean(issue, callingUser);
    }

    private WatchersBean buildBean(Issue issue, ApplicationUser callingUser) {
        try {
            Pair watcherCountList = (Pair)this.watcherService.getWatchers(issue, callingUser).get();
            List watcherUserBeans = Lists.transform((List)((List)watcherCountList.second()), this.toJson(callingUser));
            this.log.trace("Visible watchers on issue '{}': {}", (Object)issue.getKey(), (Object)watcherUserBeans);
            return WatchersBean.Builder.create().self(this.selfLink(issue)).isWatching(((List)watcherCountList.second()).contains(callingUser)).watchers(watcherUserBeans).watchCount((Integer)watcherCountList.first()).build();
        }
        catch (WatchingDisabledException e) {
            return null;
        }
    }

    private Function<ApplicationUser, UserJsonBean> toJson(final ApplicationUser callingUser) {
        return new Function<ApplicationUser, UserJsonBean>(){

            public UserJsonBean apply(ApplicationUser user) {
                return WatchersFinder.this.userBeanFactory.createBean(user, callingUser);
            }
        };
    }

    private String selfLink(Issue issue) {
        return this.uriInfo.getBaseUriBuilder().path(IssueResource.class).path(IssueResource.class, "getIssueWatchers").build(new Object[]{issue.getKey()}).toString();
    }
}

