/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.version;

import com.atlassian.jira.bc.project.version.VersionService;
import com.atlassian.jira.bc.project.version.remotelink.RemoteVersionLink;
import com.atlassian.jira.bc.project.version.remotelink.RemoteVersionLinkService;
import com.atlassian.jira.plugin.webfragment.SimpleLinkManager;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.plugin.webfragment.model.SimpleLink;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.rest.v2.common.SimpleLinkBean;
import com.atlassian.jira.rest.v2.entity.RemoteEntityLinkJsonBean;
import com.atlassian.jira.rest.v2.issue.VersionResource;
import com.atlassian.jira.rest.v2.issue.version.VersionBean;
import com.atlassian.jira.rest.v2.issue.version.VersionBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.ExecutingHttpRequest;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;

public class VersionBeanFactoryImpl
implements VersionBeanFactory {
    private final VersionService versionService;
    private final RemoteVersionLinkService remoteVersionLinkService;
    private final UriInfo info;
    private final DateFieldFormat dateFieldFormat;
    private final JiraAuthenticationContext authContext;
    private final SimpleLinkManager simpleLinkManager;

    public VersionBeanFactoryImpl(VersionService versionService, UriInfo info, DateFieldFormat dateFieldFormat, JiraAuthenticationContext authContext, SimpleLinkManager simpleLinkManager) {
        this.versionService = versionService;
        this.remoteVersionLinkService = null;
        this.authContext = authContext;
        this.simpleLinkManager = simpleLinkManager;
        this.info = info;
        this.dateFieldFormat = dateFieldFormat;
    }

    public VersionBeanFactoryImpl(VersionService versionService, RemoteVersionLinkService remoteVersionLinkService, UriInfo info, DateFieldFormat dateFieldFormat, JiraAuthenticationContext authContext, SimpleLinkManager simpleLinkManager) {
        this.versionService = versionService;
        this.remoteVersionLinkService = remoteVersionLinkService;
        this.authContext = authContext;
        this.simpleLinkManager = simpleLinkManager;
        this.info = info;
        this.dateFieldFormat = dateFieldFormat;
    }

    @Override
    public VersionBean createVersionBean(Version version) {
        return this.createVersionBean(version, false, false);
    }

    @Override
    public VersionBean createVersionBean(Version version, boolean expandOps) {
        return this.createVersionBean(version, expandOps, false);
    }

    @Override
    public VersionBean createVersionBean(Version version, boolean expandOps, boolean expandRemoteLinks) {
        String expand = this.buildExpandString(expandOps, expandRemoteLinks);
        return this.createVersionBean(version, expandOps, expandRemoteLinks, expand);
    }

    private VersionBean createVersionBean(Version version, boolean expandOps, boolean expandRemoteLinks, String expand) {
        Assertions.notNull((String)"version", (Object)version);
        Date startDate = version.getStartDate();
        Date releaseDate = version.getReleaseDate();
        String prettyStartDate = null;
        if (startDate != null) {
            prettyStartDate = this.dateFieldFormat.format(startDate);
        }
        Boolean versionOverDue = null;
        String prettyReleaseDate = null;
        if (releaseDate != null) {
            if (!version.isReleased()) {
                versionOverDue = this.versionService.isOverdue(version);
            }
            prettyReleaseDate = this.dateFieldFormat.format(releaseDate);
        }
        URI versionUri = this.createSelfURI(version);
        VersionBean.Builder versionBeanBuilder = new VersionBean.Builder().setVersion(version).setOverdue(versionOverDue).setUserStartDate(prettyStartDate).setUserReleaseDate(prettyReleaseDate).setSelf(versionUri).setProjectId(version.getProjectId()).setExpand(expand);
        if (expandOps) {
            versionBeanBuilder.setOperations(this.getOperations(version));
        }
        if (expandRemoteLinks) {
            versionBeanBuilder.setRemoteLinks(this.getRemoteLinks(version.getId(), versionUri));
        }
        return versionBeanBuilder.build();
    }

    private ArrayList<SimpleLinkBean> getOperations(Version version) {
        HttpServletRequest httpServletRequest = ExecutingHttpRequest.get();
        ApplicationUser loggedInUser = this.authContext.getUser();
        Project project = version.getProjectObject();
        Map params = MapBuilder.build((Object)"version", (Object)version, (Object)"user", (Object)loggedInUser, (Object)"project", (Object)project);
        List links = this.simpleLinkManager.getLinksForSection("atl.jira.version.admin.operations", loggedInUser, new JiraHelper(httpServletRequest, project, params));
        ArrayList<SimpleLinkBean> linkBeans = new ArrayList<SimpleLinkBean>(links.size());
        for (SimpleLink link : links) {
            linkBeans.add(new SimpleLinkBean(link));
        }
        return linkBeans;
    }

    private List<RemoteEntityLinkJsonBean> getRemoteLinks(Long versionId, URI versionUri) {
        RemoteVersionLinkService.RemoteVersionLinkListResult result = this.remoteVersionLinkService.getRemoteVersionLinksByVersionId(this.authContext.getUser(), versionId);
        if (!result.isValid()) {
            return null;
        }
        List links = result.getRemoteVersionLinks();
        ArrayList<RemoteEntityLinkJsonBean> beans = new ArrayList<RemoteEntityLinkJsonBean>(links.size());
        for (RemoteVersionLink link : links) {
            URI self = UriBuilder.fromUri((URI)versionUri).path("remotelink").path(link.getGlobalId()).build(new Object[0]);
            beans.add(new RemoteEntityLinkJsonBean().self(self).name(((Version)link.getEntity()).getName()).link(link.getJsonString()));
        }
        return beans;
    }

    @Override
    public List<VersionBean> createVersionBeans(Collection<? extends Version> versions) {
        return this.createVersionBeans(versions, false, false);
    }

    @Override
    public List<VersionBean> createVersionBeans(Collection<? extends Version> versions, boolean expandOps) {
        return this.createVersionBeans(versions, expandOps, false);
    }

    @Override
    public List<VersionBean> createVersionBeans(Collection<? extends Version> versions, boolean expandOps, boolean expandRemoteLinks) {
        Assertions.containsNoNulls((String)"versions", versions);
        ArrayList<VersionBean> beans = new ArrayList<VersionBean>(versions.size());
        String expand = this.buildExpandString(expandOps, expandRemoteLinks);
        for (Version version : versions) {
            beans.add(this.createVersionBean(version, expandOps, expandRemoteLinks, expand));
        }
        return beans;
    }

    private URI createSelfURI(Version version) {
        return this.info.getBaseUriBuilder().path(VersionResource.class).path(version.getId().toString()).build(new Object[0]);
    }

    private String buildExpandString(boolean expandOps, boolean expandRemoteLinks) {
        StringBuilder expand = new StringBuilder();
        if (expandOps) {
            expand.append("operations").append(',');
        }
        if (expandRemoteLinks) {
            expand.append("remotelinks").append(',');
        }
        if (expand.length() == 0) {
            return null;
        }
        expand.setLength(expand.length() - 1);
        return expand.toString();
    }
}

