/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.users;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.user.search.UserSearchParams;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.bc.user.search.UserSearchUtilities;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.RESTException;
import com.atlassian.jira.rest.v2.issue.UserPickerResultsBean;
import com.atlassian.jira.rest.v2.issue.UserPickerUser;
import com.atlassian.jira.rest.v2.issue.users.UserPickerResourceHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;
import com.atlassian.jira.util.DelimeterInserter;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserPickerResourceHelperImpl
implements UserPickerResourceHelper {
    private final UserSearchService userSearchService;
    private final I18nHelper i18n;
    private final AvatarService avatarService;
    private final JiraAuthenticationContext authContext;
    private final PermissionManager permissionManager;

    @Autowired
    public UserPickerResourceHelperImpl(UserSearchService userSearchService, I18nHelper i18n, AvatarService avatarService, JiraAuthenticationContext authContext, PermissionManager permissionManager) {
        this.userSearchService = userSearchService;
        this.i18n = i18n;
        this.avatarService = avatarService;
        this.authContext = authContext;
        this.permissionManager = permissionManager;
    }

    @Override
    public UserPickerResultsBean findUsersAsBean(String query, Integer maxResults, Boolean showAvatar, List<String> excludeUsers) {
        return this.findUsersAsBean(query, maxResults, showAvatar, excludeUsers, UserSearchParams.ACTIVE_USERS_IGNORE_EMPTY_QUERY);
    }

    @Override
    public UserPickerResultsBean findUsersAsBean(String query, Integer maxResults, Boolean showAvatar, List<String> excludeUsers, UserSearchParams userSearchParams) {
        List<ApplicationUser> page;
        List<Object> users = Lists.newArrayList();
        if (this.permissionManager.hasPermission(27, this.authContext.getUser())) {
            users = this.findUsers(query, userSearchParams);
            page = this.limitUserSearch(0, maxResults, users, excludeUsers);
        } else {
            ApplicationUser user = this.getUserByName(query);
            if (user != null) {
                users.add(user);
            }
            page = this.limitUserSearch(0, 1, users, excludeUsers);
        }
        return this.makeUserPickerBean(users, page, query, showAvatar);
    }

    @Override
    public List<ApplicationUser> limitUserSearch(Integer startAt, Integer maxResults, Iterable<ApplicationUser> users, Iterable<String> excludeUsers) {
        Iterable filteredUsers;
        int limit;
        int skip = startAt != null && startAt >= 0 ? startAt : 0;
        int n = limit = maxResults != null && maxResults >= 0 ? Math.min(1000, maxResults) : 50;
        if (excludeUsers == null) {
            filteredUsers = users;
        } else {
            final ImmutableSet filter = ImmutableSet.copyOf(excludeUsers);
            filteredUsers = Iterables.filter(users, (Predicate)new Predicate<ApplicationUser>(){

                public boolean apply(ApplicationUser user) {
                    return !filter.contains((Object)user.getName());
                }
            });
        }
        return ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.skip(filteredUsers, (int)skip), (int)limit));
    }

    @Override
    public List<ApplicationUser> findActiveUsers(String searchString) {
        return this.findUsers(searchString, true, false);
    }

    @Override
    public List<ApplicationUser> findUsers(String searchString, Boolean includeActive, Boolean includeInactive) {
        return this.findUsers(searchString, includeActive, includeInactive, false);
    }

    @Override
    public List<ApplicationUser> findUsers(String searchString, Boolean includeActive, Boolean includeInactive, boolean allowEmptySearchString) {
        return this.findUsers(searchString, includeActive, includeInactive, allowEmptySearchString, null);
    }

    @Override
    public List<ApplicationUser> findUsers(String searchString, Boolean includeActive, Boolean includeInactive, boolean allowEmptySearchString, Predicate<User> userFilter) {
        return this.findUsers(searchString, includeActive, includeInactive, allowEmptySearchString, userFilter, null);
    }

    @Override
    public List<ApplicationUser> findUsers(String searchString, Boolean includeActive, Boolean includeInactive, boolean allowEmptySearchString, Predicate<User> userFilter, Integer maxResults) {
        if (!allowEmptySearchString && searchString == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.user.error.no.username.param")));
        }
        UserSearchParams userSearchParams = UserSearchParams.builder().includeActive(includeActive == null || includeActive != false).includeInactive(includeInactive != null && includeInactive != false).allowEmptyQuery(allowEmptySearchString).filter(userFilter).maxResults(maxResults).build();
        return this.userSearchService.findUsers(this.getContext(), searchString, userSearchParams);
    }

    @Override
    public List<ApplicationUser> findUsers(String searchString, UserSearchParams userSearchParams) {
        if (!userSearchParams.allowEmptyQuery() && searchString == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.user.error.no.username.param")));
        }
        return this.userSearchService.findUsers(this.getContext(), searchString, userSearchParams);
    }

    @Override
    public ApplicationUser getUserByName(String userName) {
        if (userName == null) {
            throw new RESTException(Response.Status.BAD_REQUEST, ErrorCollection.of(this.i18n.getText("rest.user.error.no.username.param")));
        }
        return this.userSearchService.getUserByName(this.getContext(), userName);
    }

    private UserPickerResultsBean makeUserPickerBean(Collection<ApplicationUser> users, Collection<ApplicationUser> page, String query, Boolean showAvatar) {
        int total = users.size();
        int showing = page.size();
        boolean canShowEmailAddresses = this.userSearchService.canShowEmailAddresses(this.getContext());
        if (showAvatar == null) {
            showAvatar = false;
        }
        ArrayList<UserPickerUser> beans = new ArrayList<UserPickerUser>(page.size());
        for (ApplicationUser user : page) {
            String html = this.formatUser(user, query, canShowEmailAddresses);
            beans.add(new UserPickerUser(user.getName(), ApplicationUsers.getKeyFor((ApplicationUser)user), user.getDisplayName(), html, showAvatar != false ? this.avatarService.getAvatarURL(user, user.getName(), Avatar.Size.SMALL) : null));
        }
        return new UserPickerResultsBean(beans, this.i18n.getText("jira.ajax.autocomplete.user.more.results", String.valueOf(showing), String.valueOf(total)), total);
    }

    private String formatUser(ApplicationUser user, String query, boolean canShoweEmailAddresses) {
        DelimeterInserter delimeterInserter = new DelimeterInserter("<strong>", "</strong>");
        delimeterInserter.setConsideredWhitespace(UserSearchUtilities.SEPARATORS_STRING);
        String[] terms = new String[]{query};
        String userFullName = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getDisplayName()), terms);
        String userName = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getName()), terms);
        StringBuilder sb = new StringBuilder();
        sb.append(userFullName);
        if (canShoweEmailAddresses) {
            String userEmail = delimeterInserter.insert(TextUtils.htmlEncode((String)user.getEmailAddress()), terms);
            sb.append(" - ");
            sb.append(userEmail);
        }
        sb.append(" (");
        sb.append(userName);
        sb.append(")");
        return sb.toString();
    }

    JiraServiceContext getContext() {
        ApplicationUser user = this.authContext.getUser();
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        return new JiraServiceContextImpl(user, (com.atlassian.jira.util.ErrorCollection)errorCollection);
    }
}

