/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.v2.issue.users;

import com.atlassian.jira.rest.v2.issue.Examples;
import com.atlassian.jira.rest.v2.issue.users.IssueInvolvementBean;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.collect.ImmutableList;
import java.net.URI;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="user")
public class UserIssueRelevanceBean {
    @XmlElement
    private URI self;
    @XmlElement
    private String key;
    @XmlElement
    private String name;
    @XmlElement
    private String emailAddress;
    @XmlElement
    private Map<String, URI> avatarUrls;
    @XmlElement
    private String displayName;
    @XmlElement
    private boolean active;
    @XmlElement
    private String timeZone;
    @XmlElement
    private String locale;
    @XmlElement
    private List<IssueInvolvementBean> issueInvolvements;
    @XmlElement
    private Integer highestIssueInvolvementRank;
    @XmlElement
    private Long latestCommentCreationTime;
    public static final UserIssueRelevanceBean DOC_EXAMPLE = new UserIssueRelevanceBean();

    UserIssueRelevanceBean() {
    }

    public UserIssueRelevanceBean(URI self, String key, String name, String displayName, boolean active, String emailAddress, Map<String, URI> avatarUrls, TimeZone timeZone, Locale locale, List<IssueInvolvementBean> issueInvolvements, Optional<Integer> highestIssueInvolvementRank, Optional<Date> latestCommentCreationTime) {
        this.self = Objects.requireNonNull(self);
        this.key = Objects.requireNonNull(key);
        this.name = Objects.requireNonNull(name);
        this.displayName = Objects.requireNonNull(displayName);
        this.active = active;
        this.emailAddress = emailAddress;
        this.avatarUrls = Objects.requireNonNull(avatarUrls);
        this.timeZone = timeZone != null ? timeZone.getID() : null;
        this.locale = locale != null ? locale.toString() : null;
        this.issueInvolvements = ImmutableList.copyOf(issueInvolvements);
        this.highestIssueInvolvementRank = highestIssueInvolvementRank.orElse(null);
        this.latestCommentCreationTime = latestCommentCreationTime.map(date -> date.getTime()).orElse(null);
    }

    public URI getSelf() {
        return this.self;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, URI> getAvatarUrls() {
        return this.avatarUrls;
    }

    public List<IssueInvolvementBean> getIssueInvolvements() {
        return this.issueInvolvements;
    }

    public Integer getHighestIssueInvolvementRank() {
        return this.highestIssueInvolvementRank;
    }

    public Long getLatestCommentCreationTime() {
        return this.latestCommentCreationTime;
    }

    static {
        UserIssueRelevanceBean.DOC_EXAMPLE.self = Examples.restURI("user?username=fred");
        UserIssueRelevanceBean.DOC_EXAMPLE.name = "fred";
        UserIssueRelevanceBean.DOC_EXAMPLE.emailAddress = "fred@example.com";
        UserIssueRelevanceBean.DOC_EXAMPLE.displayName = "Fred F. User";
        UserIssueRelevanceBean.DOC_EXAMPLE.active = true;
        UserIssueRelevanceBean.DOC_EXAMPLE.avatarUrls = MapBuilder.newBuilder().add((Object)"16x16", (Object)Examples.jiraURI("secure/useravatar?size=xsmall&ownerId=fred")).add((Object)"24x24", (Object)Examples.jiraURI("secure/useravatar?size=small&ownerId=fred")).add((Object)"32x32", (Object)Examples.jiraURI("secure/useravatar?size=medium&ownerId=fred")).add((Object)"48x48", (Object)Examples.jiraURI("secure/useravatar?size=large&ownerId=fred")).toMap();
        UserIssueRelevanceBean.DOC_EXAMPLE.timeZone = "Australia/Sydney";
        UserIssueRelevanceBean.DOC_EXAMPLE.issueInvolvements = ImmutableList.of((Object)IssueInvolvementBean.DOC_EXAMPLE);
        UserIssueRelevanceBean.DOC_EXAMPLE.highestIssueInvolvementRank = 0;
        UserIssueRelevanceBean.DOC_EXAMPLE.latestCommentCreationTime = 1458688056272L;
    }
}

